/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.yum.internal.rest;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.restlet.Context;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.restlet.resource.StringRepresentation;
import org.restlet.resource.Variant;
import org.sonatype.configuration.ConfigurationException;
import org.sonatype.configuration.validation.InvalidConfigurationException;
import org.sonatype.nexus.plugins.capabilities.CapabilityNotFoundException;
import org.sonatype.nexus.plugins.capabilities.CapabilityReference;
import org.sonatype.nexus.plugins.capabilities.CapabilityRegistry;
import org.sonatype.nexus.rest.AbstractNexusPlexusResource;
import org.sonatype.nexus.yum.Yum;
import org.sonatype.nexus.yum.YumHosted;
import org.sonatype.nexus.yum.YumRegistry;
import org.sonatype.nexus.yum.internal.capabilities.GenerateMetadataCapability;
import org.sonatype.nexus.yum.internal.capabilities.GenerateMetadataCapabilityConfiguration;
import org.sonatype.nexus.yum.internal.capabilities.GenerateMetadataCapabilityDescriptor;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;
import org.sonatype.plexus.rest.resource.PlexusResource;

@Path(value="/yum/alias/{repositoryId}/{alias}")
@Produces(value={"application/xml", "application/json", "text/plain"})
@Named
@Singleton
public class AliasResource
extends AbstractNexusPlexusResource
implements PlexusResource {
    public static final String URL_PREFIX = "yum/alias";
    private static final String PATH_PATTERN_TO_PROTECT = "/yum/alias/**";
    public static final String REPOSITORY_ID_PARAM = "repositoryId";
    public static final String ALIAS_PARAM = "alias";
    public static final String RESOURCE_URI = "/yum/alias/{repositoryId}/{alias}";
    private final YumRegistry yumRegistry;
    private final CapabilityRegistry capabilityRegistry;

    @Inject
    public AliasResource(YumRegistry yumRegistry, CapabilityRegistry capabilityRegistry) {
        this.yumRegistry = (YumRegistry)Preconditions.checkNotNull((Object)yumRegistry);
        this.capabilityRegistry = (CapabilityRegistry)Preconditions.checkNotNull((Object)capabilityRegistry);
        this.setModifiable(true);
        this.setRequireStrictChecking(false);
    }

    public Object get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        String repositoryId = this.getAttributeAsString(request, REPOSITORY_ID_PARAM);
        if (repositoryId == null) {
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Repository Id must be specified");
        }
        String alias = this.getAttributeAsString(request, ALIAS_PARAM);
        if (alias == null) {
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Alias must be specified");
        }
        Yum yum = this.yumRegistry.get(repositoryId);
        if (yum == null) {
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, "Could not find Yum repository with id '" + repositoryId + "'");
        }
        if (!(yum instanceof YumHosted)) {
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Repository " + repositoryId + " does not support versions");
        }
        YumHosted yumHosted = (YumHosted)yum;
        String version = yumHosted.getVersion(alias);
        if (version == null) {
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, "Could not find alias '" + alias + "' for repository '" + repositoryId + "'");
        }
        return new StringRepresentation((CharSequence)version);
    }

    public Object post(Context context, Request request, Response response, Object payload) throws ResourceException {
        final String repositoryId = this.getAttributeAsString(request, REPOSITORY_ID_PARAM);
        if (repositoryId == null) {
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Repository Id must be specified");
        }
        String alias = this.getAttributeAsString(request, ALIAS_PARAM);
        if (alias == null) {
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Alias must be specified");
        }
        if (payload == null || !String.class.isAssignableFrom(payload.getClass())) {
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Please provide a valid artifact version.");
        }
        Yum yum = this.yumRegistry.get(repositoryId);
        if (yum == null) {
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, "Could not find Yum repository with id '" + repositoryId + "'");
        }
        Collection capabilities = this.capabilityRegistry.get((Predicate)new Predicate<CapabilityReference>(){

            public boolean apply(CapabilityReference reference) {
                String capabilityRepositoryId = (String)reference.context().properties().get("repository");
                return GenerateMetadataCapabilityDescriptor.TYPE.equals((Object)reference.context().type()) && repositoryId.equals(capabilityRepositoryId);
            }
        });
        if (capabilities.isEmpty()) {
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, "Could not find Yum repository with id '" + repositoryId + "'");
        }
        CapabilityReference capabilityReference = (CapabilityReference)capabilities.iterator().next();
        GenerateMetadataCapabilityConfiguration configuration = (GenerateMetadataCapabilityConfiguration)((GenerateMetadataCapability)capabilityReference.capabilityAs(GenerateMetadataCapability.class)).getConfig();
        String version = payload.toString();
        HashMap newAliases = Maps.newHashMap();
        newAliases.putAll(configuration.aliases());
        newAliases.put(alias, version);
        GenerateMetadataCapabilityConfiguration newConfiguration = new GenerateMetadataCapabilityConfiguration(configuration.repository(), newAliases, configuration.shouldProcessDeletes(), configuration.deleteProcessingDelay(), configuration.getYumGroupsDefinitionFile());
        try {
            this.capabilityRegistry.update(capabilityReference.context().id(), capabilityReference.context().isEnabled(), capabilityReference.context().notes(), newConfiguration.asMap());
        }
        catch (CapabilityNotFoundException e) {
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, e.getMessage());
        }
        catch (InvalidConfigurationException e) {
            this.handleConfigurationException((ConfigurationException)e);
        }
        catch (IOException e) {
            throw new ResourceException(Status.SERVER_ERROR_INTERNAL, "Could not manage capabilities configuration persistence store");
        }
        return new StringRepresentation((CharSequence)version, MediaType.TEXT_PLAIN);
    }

    private String getAttributeAsString(Request request, String attrName) {
        Object attrValue = request.getAttributes().get(attrName);
        return attrValue != null ? attrValue.toString() : null;
    }

    public String getResourceUri() {
        return RESOURCE_URI;
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor(PATH_PATTERN_TO_PROTECT, "authcBasic,perms[nexus:yumAlias]");
    }

    public Object getPayloadInstance(Method method) {
        if (Method.POST.equals((Object)method)) {
            return "";
        }
        return null;
    }

    public Object getPayloadInstance() {
        return null;
    }
}

