/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.yum.internal.rest;

import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.Representation;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.sonatype.nexus.yum.YumRepository;
import org.sonatype.nexus.yum.internal.rest.IndexRepresentation;
import org.sonatype.nexus.yum.internal.rest.UrlPathInterpretation;
import org.sonatype.nexus.yum.internal.rest.UrlPathParser;
import org.sonatype.nexus.yum.internal.rest.YumFileRepresentation;
import org.sonatype.plexus.rest.resource.AbstractPlexusResource;

public abstract class AbstractYumRepositoryResource
extends AbstractPlexusResource {
    private final UrlPathParser requestSegmentInterpetor = new UrlPathParser(this.getUrlPrefixName(), this.getSegmentCountAfterPrefix());

    public Object getPayloadInstance() {
        return null;
    }

    public Object get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        try {
            UrlPathInterpretation interpretation = this.requestSegmentInterpetor.parse(request);
            if (interpretation.isRedirect()) {
                response.redirectPermanent(interpretation.getRedirectUri());
                return null;
            }
            return this.createRepresentation(interpretation, this.getYumRepository(request, interpretation));
        }
        catch (ResourceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceException(Status.SERVER_ERROR_INTERNAL, (Throwable)e);
        }
    }

    private Representation createRepresentation(UrlPathInterpretation interpretation, YumRepository yumRepository) {
        return interpretation.isIndex() ? new IndexRepresentation(interpretation, yumRepository) : new YumFileRepresentation(interpretation, yumRepository);
    }

    protected abstract String getUrlPrefixName();

    protected abstract YumRepository getYumRepository(Request var1, UrlPathInterpretation var2) throws Exception;

    protected abstract int getSegmentCountAfterPrefix();
}

