/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.yum.internal.capabilities;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.capability.support.CapabilityDescriptorSupport;
import org.sonatype.nexus.formfields.FormField;
import org.sonatype.nexus.formfields.NumberTextFormField;
import org.sonatype.nexus.formfields.StringTextFormField;
import org.sonatype.nexus.plugins.capabilities.CapabilityIdentity;
import org.sonatype.nexus.plugins.capabilities.CapabilityType;
import org.sonatype.nexus.plugins.capabilities.Tag;
import org.sonatype.nexus.plugins.capabilities.Taggable;
import org.sonatype.nexus.plugins.capabilities.Validator;
import org.sonatype.nexus.plugins.capabilities.support.validator.Validators;
import org.sonatype.sisu.goodies.i18n.I18N;
import org.sonatype.sisu.goodies.i18n.MessageBundle;

@Singleton
@Named(value="yum")
public class YumCapabilityDescriptor
extends CapabilityDescriptorSupport
implements Taggable {
    public static final String TYPE_ID = "yum";
    public static final CapabilityType TYPE = CapabilityType.capabilityType((String)"yum");
    private static final Messages messages = (Messages)I18N.create(Messages.class);
    private final Validators validators;
    private final List<FormField> formFields;

    @Inject
    public YumCapabilityDescriptor(Validators validators) {
        this.validators = validators;
        this.formFields = Lists.newArrayList((Object[])new FormField[]{new NumberTextFormField("maxNumberParallelThreads", messages.maxNumberParallelThreadsLabel(), messages.maxNumberParallelThreadsHelp(), false).withInitialValue((Number)10), new StringTextFormField("createrepoPath", messages.createrepoPathLabel(), messages.createrepoPathHelp(), false), new StringTextFormField("mergerepoPath", messages.mergerepoPathLabel(), messages.mergerepoPathHelp(), false)});
    }

    public Validator validator() {
        return this.validators.logical().and(new Validator[]{this.validators.capability().uniquePer(TYPE, new String[0])});
    }

    public Validator validator(CapabilityIdentity id) {
        return this.validators.logical().and(new Validator[]{this.validators.capability().uniquePerExcluding(id, TYPE, new String[0])});
    }

    public CapabilityType type() {
        return TYPE;
    }

    public String name() {
        return messages.name();
    }

    public List<FormField> formFields() {
        return this.formFields;
    }

    public Set<Tag> getTags() {
        return Tag.tags((Tag[])new Tag[]{Tag.categoryTag((String)"Yum")});
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="Yum: Configuration")
        public String name();

        @MessageBundle.DefaultMessage(value="Max number of parallel threads")
        public String maxNumberParallelThreadsLabel();

        @MessageBundle.DefaultMessage(value="Maximum number of threads to be used for generating Yum repositories (default 10 threads)")
        public String maxNumberParallelThreadsHelp();

        @MessageBundle.DefaultMessage(value="Path of \"createrepo\"")
        public String createrepoPathLabel();

        @MessageBundle.DefaultMessage(value="Path of \"createrepo\" (e.g. /usr/bin/createrepo)")
        public String createrepoPathHelp();

        @MessageBundle.DefaultMessage(value="Path of \"mergerepo\"")
        public String mergerepoPathLabel();

        @MessageBundle.DefaultMessage(value="Path of \"mergerepo\" (e.g. /usr/bin/mergerepo)")
        public String mergerepoPathHelp();
    }
}

