/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.yum.internal.capabilities;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class YumCapabilityConfiguration {
    public static final String MAX_NUMBER_PARALLEL_THREADS = "maxNumberParallelThreads";
    public static final String CREATEREPO_PATH = "createrepoPath";
    public static final String MERGEREPO_PATH = "mergerepoPath";
    private int maxParallelThreads;
    private String createrepoPath = "createrepo";
    private String mergerepoPath = "mergerepo";

    public YumCapabilityConfiguration(int maxParallelThreads) {
        this.maxParallelThreads = maxParallelThreads;
    }

    public YumCapabilityConfiguration(Map<String, String> properties) {
        int maxParallelThreads = 10;
        try {
            maxParallelThreads = Integer.parseInt(properties.get(MAX_NUMBER_PARALLEL_THREADS));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.maxParallelThreads = maxParallelThreads;
        this.createrepoPath = properties.get(CREATEREPO_PATH);
        if (StringUtils.isBlank((String)this.createrepoPath)) {
            this.createrepoPath = "createrepo";
        }
        this.mergerepoPath = properties.get(MERGEREPO_PATH);
        if (StringUtils.isBlank((String)this.mergerepoPath)) {
            this.mergerepoPath = "mergerepo";
        }
    }

    public int maxNumberParallelThreads() {
        return this.maxParallelThreads;
    }

    public String getCreaterepoPath() {
        return this.createrepoPath;
    }

    public String getMergerepoPath() {
        return this.mergerepoPath;
    }

    public Map<String, String> asMap() {
        HashMap props = Maps.newHashMap();
        props.put(MAX_NUMBER_PARALLEL_THREADS, String.valueOf(this.maxParallelThreads));
        props.put(CREATEREPO_PATH, this.createrepoPath);
        props.put(MERGEREPO_PATH, this.mergerepoPath);
        return props;
    }
}

