/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.yum.internal.capabilities;

import com.google.common.base.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.jetbrains.annotations.NonNls;
import org.sonatype.aether.util.version.GenericVersionScheme;
import org.sonatype.aether.version.Version;
import org.sonatype.aether.version.VersionConstraint;
import org.sonatype.nexus.capability.support.CapabilitySupport;
import org.sonatype.nexus.plugins.capabilities.Condition;
import org.sonatype.nexus.plugins.capabilities.Evaluable;
import org.sonatype.nexus.yum.YumRegistry;
import org.sonatype.nexus.yum.internal.capabilities.YumCapabilityConfiguration;
import org.sonatype.nexus.yum.internal.task.CommandLineExecutor;

@Named(value="yum")
public class YumCapability
extends CapabilitySupport<YumCapabilityConfiguration> {
    @NonNls
    public static final String NL = System.getProperty("line.separator");
    private final YumRegistry yumRegistry;
    private final CommandLineExecutor commandLineExecutor;
    private String binariesLog;
    private String binariesNotAvailableMessage;

    @Inject
    public YumCapability(YumRegistry yumRegistry, CommandLineExecutor commandLineExecutor) {
        this.yumRegistry = (YumRegistry)Preconditions.checkNotNull((Object)yumRegistry);
        this.commandLineExecutor = (CommandLineExecutor)Preconditions.checkNotNull((Object)commandLineExecutor);
    }

    protected YumCapabilityConfiguration createConfig(Map<String, String> properties) throws Exception {
        return new YumCapabilityConfiguration(properties);
    }

    protected void onActivate(YumCapabilityConfiguration config) throws Exception {
        this.yumRegistry.setMaxNumberOfParallelThreads(config.maxNumberParallelThreads());
        this.yumRegistry.setCreaterepoPath(config.getCreaterepoPath());
        this.yumRegistry.setMergerepoPath(config.getMergerepoPath());
    }

    public Condition activationCondition() {
        return this.conditions().capabilities().evaluable(new Evaluable(){

            public boolean isSatisfied() {
                StringBuilder message = new StringBuilder();
                StringBuilder verificationLog = new StringBuilder();
                this.validate("createrepo", ((YumCapabilityConfiguration)YumCapability.this.getConfig()).getCreaterepoPath(), "[0.9.9,)", message, verificationLog);
                verificationLog.append(NL);
                this.validate("mergerepo", ((YumCapabilityConfiguration)YumCapability.this.getConfig()).getMergerepoPath(), "[0.1,)", message, verificationLog);
                YumCapability.this.binariesLog = verificationLog.toString().replace(NL, "<br/>");
                YumCapability.this.binariesNotAvailableMessage = null;
                if (message.length() > 0) {
                    YumCapability.this.binariesNotAvailableMessage = message.toString();
                }
                return YumCapability.this.binariesNotAvailableMessage == null;
            }

            public String explainSatisfied() {
                return "\"createrepo\" and \"mergerepo\" are available";
            }

            public String explainUnsatisfied() {
                return YumCapability.this.binariesNotAvailableMessage;
            }

            private void validate(String type, String path, String versionConstraint, StringBuilder message, StringBuilder verificationLog) {
                String and = message.length() > 0 ? " and " : "";
                verificationLog.append("\"").append(type).append("\" version:").append(NL);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    if (YumCapability.this.commandLineExecutor.exec(path + " --version", baos, baos) == 0) {
                        String versionOutput = new String(baos.toByteArray());
                        verificationLog.append(versionOutput);
                        this.ensureVersionCompatible(type, versionOutput, versionConstraint, message, verificationLog);
                    } else {
                        message.append(and).append("\"").append(type).append("\" not available");
                        verificationLog.append(new String(baos.toByteArray()));
                    }
                }
                catch (IOException e) {
                    message.append(and).append("\"").append(type).append("\" not available");
                    verificationLog.append(new String(baos.toByteArray()));
                    verificationLog.append(e.getMessage()).append(NL);
                }
            }

            private void ensureVersionCompatible(String type, String rawVersion, String versionConstraint, StringBuilder message, StringBuilder verificationLog) {
                String version = this.parseVersion(type, rawVersion);
                if (version == null) {
                    verificationLog.append("WARNING: Could not determine version!").append(NL);
                } else {
                    try {
                        GenericVersionScheme scheme = new GenericVersionScheme();
                        VersionConstraint constraint = scheme.parseVersionConstraint(versionConstraint);
                        Version _version = scheme.parseVersion(version);
                        if (!constraint.containsVersion(_version)) {
                            message.append("\"").append(type).append("\" incompatible version");
                            verificationLog.append(NL);
                            verificationLog.append("Incompatible ").append(type).append(" version detected:").append(NL);
                            verificationLog.append("Detected version: ").append(_version).append(NL);
                            verificationLog.append("Compatible version constraint: ").append(constraint).append(NL);
                        }
                    }
                    catch (Exception e) {
                        YumCapability.this.log.debug("Could not parse version from " + version, (Throwable)e);
                        verificationLog.append("WARNING: Could not parse version from ").append(version).append("!").append(NL);
                    }
                }
            }

            private String parseVersion(String type, String rawVersion) {
                try {
                    String[] lines;
                    for (String line : lines = rawVersion.split("\n")) {
                        if (!(line = line.trim()).startsWith(type + " ")) continue;
                        String[] parts = line.split("\\s");
                        return parts[1];
                    }
                }
                catch (Exception e) {
                    YumCapability.this.log.debug("Could not determine version", (Throwable)e);
                }
                return null;
            }
        });
    }

    protected String renderStatus() {
        return this.binariesLog;
    }
}

