/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.yum.internal.capabilities;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.InputStream;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.sonatype.nexus.capability.support.CapabilitySupport;
import org.sonatype.nexus.plugins.capabilities.Condition;
import org.sonatype.nexus.plugins.capabilities.Tag;
import org.sonatype.nexus.plugins.capabilities.Taggable;
import org.sonatype.nexus.plugins.capabilities.support.condition.RepositoryConditions;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.maven.MavenRepository;
import org.sonatype.nexus.proxy.registry.RepositoryRegistry;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.yum.Yum;
import org.sonatype.nexus.yum.YumRegistry;
import org.sonatype.nexus.yum.internal.YumConfigContentGenerator;
import org.sonatype.nexus.yum.internal.capabilities.MetadataCapabilityConfigurationSupport;
import org.sonatype.nexus.yum.internal.capabilities.YumCapabilityDescriptor;

public abstract class MetadataCapabilitySupport<C extends MetadataCapabilityConfigurationSupport>
extends CapabilitySupport<C>
implements Taggable {
    private final YumRegistry yumRegistry;
    private final RepositoryRegistry repositoryRegistry;

    @Inject
    public MetadataCapabilitySupport(YumRegistry yumRegistry, RepositoryRegistry repositoryRegistry) {
        this.yumRegistry = (YumRegistry)Preconditions.checkNotNull((Object)yumRegistry);
        this.repositoryRegistry = (RepositoryRegistry)Preconditions.checkNotNull((Object)repositoryRegistry);
    }

    public String renderDescription() {
        if (this.isConfigured()) {
            try {
                return this.repositoryRegistry.getRepository(((MetadataCapabilityConfigurationSupport)this.getConfig()).repository()).getName();
            }
            catch (NoSuchRepositoryException e) {
                return ((MetadataCapabilityConfigurationSupport)this.getConfig()).repository();
            }
        }
        return null;
    }

    public void onUpdate(C config) throws Exception {
        Yum yum = this.yumRegistry.get(((MetadataCapabilityConfigurationSupport)config).repository());
        if (yum != null) {
            this.configureYum(yum, config);
        }
    }

    public void onActivate(C config) {
        try {
            Repository repository = this.repositoryRegistry.getRepository(((MetadataCapabilityConfigurationSupport)config).repository());
            this.configureYum(this.yumRegistry.register((MavenRepository)repository.adaptToFacet(MavenRepository.class)), config);
        }
        catch (NoSuchRepositoryException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void onPassivate(C config) {
        this.yumRegistry.unregister(((MetadataCapabilityConfigurationSupport)config).repository());
    }

    public Condition activationCondition() {
        return this.conditions().logical().and(new Condition[]{this.conditions().capabilities().capabilityOfTypeActive(YumCapabilityDescriptor.TYPE), this.conditions().repository().repositoryIsInService(new RepositoryConditions.RepositoryId(){

            public String get() {
                return MetadataCapabilitySupport.this.isConfigured() ? ((MetadataCapabilityConfigurationSupport)MetadataCapabilitySupport.this.getConfig()).repository() : null;
            }
        }), this.conditions().capabilities().passivateCapabilityWhenPropertyChanged(new String[]{"repository"})});
    }

    public Condition validityCondition() {
        return this.conditions().repository().repositoryExists(new RepositoryConditions.RepositoryId(){

            public String get() {
                return MetadataCapabilitySupport.this.isConfigured() ? ((MetadataCapabilityConfigurationSupport)MetadataCapabilitySupport.this.getConfig()).repository() : null;
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String renderStatus() {
        if (!this.isConfigured()) return null;
        try {
            Repository repository = this.repositoryRegistry.getRepository(((MetadataCapabilityConfigurationSupport)this.getConfig()).repository());
            StorageItem storageItem = repository.retrieveItem(new ResourceStoreRequest(YumConfigContentGenerator.configFilePath(repository.getId()), true));
            if (!(storageItem instanceof StorageFileItem)) return null;
            try (InputStream in = ((StorageFileItem)storageItem).getInputStream();){
                String string = "<b>Example Yum configuration file:</b><br/><br/><pre>" + IOUtils.toString((InputStream)in) + "</pre>";
                return string;
            }
        }
        catch (Exception e) {
            return null;
        }
    }

    void configureYum(Yum yum, C config) {
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + (this.isConfigured() ? "{repository=" + ((MetadataCapabilityConfigurationSupport)this.getConfig()).repository() + "}" : "");
    }

    public Set<Tag> getTags() {
        return Tag.tags((Tag[])new Tag[]{Tag.repositoryTag((String)this.renderDescription())});
    }
}

