/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.yum.internal.capabilities;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.capability.support.CapabilityDescriptorSupport;
import org.sonatype.nexus.formfields.FormField;
import org.sonatype.nexus.formfields.RepositoryCombobox;
import org.sonatype.nexus.plugins.capabilities.CapabilityIdentity;
import org.sonatype.nexus.plugins.capabilities.CapabilityType;
import org.sonatype.nexus.plugins.capabilities.Tag;
import org.sonatype.nexus.plugins.capabilities.Taggable;
import org.sonatype.nexus.plugins.capabilities.Validator;
import org.sonatype.nexus.proxy.repository.GroupRepository;
import org.sonatype.sisu.goodies.i18n.I18N;
import org.sonatype.sisu.goodies.i18n.MessageBundle;

@Singleton
@Named(value="yum.merge")
public class MergeMetadataCapabilityDescriptor
extends CapabilityDescriptorSupport
implements Taggable {
    public static final String TYPE_ID = "yum.merge";
    public static final CapabilityType TYPE = CapabilityType.capabilityType((String)"yum.merge");
    private static final Messages messages = (Messages)I18N.create(Messages.class);
    private final List<FormField> formFields = Lists.newArrayList((Object[])new FormField[]{new RepositoryCombobox("repository", messages.repositoryLabel(), messages.repositoryHelp(), true).includingAnyOfFacets(new Class[]{GroupRepository.class})});

    @Inject
    public MergeMetadataCapabilityDescriptor() {
    }

    public CapabilityType type() {
        return TYPE;
    }

    public String name() {
        return messages.name();
    }

    public List<FormField> formFields() {
        return this.formFields;
    }

    public Validator validator() {
        return this.validators().logical().and(new Validator[]{this.validators().repository().repositoryOfType(TYPE, "repository", GroupRepository.class), this.validators().capability().uniquePer(TYPE, new String[]{"repository"})});
    }

    public Validator validator(CapabilityIdentity id) {
        return this.validators().logical().and(new Validator[]{this.validators().repository().repositoryOfType(TYPE, "repository", GroupRepository.class), this.validators().capability().uniquePerExcluding(id, TYPE, new String[]{"repository"})});
    }

    protected String renderAbout() throws Exception {
        return this.render("yum.merge-about.vm");
    }

    public Set<Tag> getTags() {
        return Tag.tags((Tag[])new Tag[]{Tag.categoryTag((String)"Yum")});
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="Yum: Merge Metadata")
        public String name();

        @MessageBundle.DefaultMessage(value="Group")
        public String repositoryLabel();

        @MessageBundle.DefaultMessage(value="Select the group that should merge Yum metadata of group members")
        public String repositoryHelp();
    }
}

