/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.yum.internal.capabilities;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.capability.support.CapabilityDescriptorSupport;
import org.sonatype.nexus.formfields.CheckboxFormField;
import org.sonatype.nexus.formfields.FormField;
import org.sonatype.nexus.formfields.NumberTextFormField;
import org.sonatype.nexus.formfields.RepositoryCombobox;
import org.sonatype.nexus.formfields.StringTextFormField;
import org.sonatype.nexus.formfields.TextAreaFormField;
import org.sonatype.nexus.plugins.capabilities.CapabilityIdentity;
import org.sonatype.nexus.plugins.capabilities.CapabilityType;
import org.sonatype.nexus.plugins.capabilities.Tag;
import org.sonatype.nexus.plugins.capabilities.Taggable;
import org.sonatype.nexus.plugins.capabilities.Validator;
import org.sonatype.nexus.proxy.maven.MavenHostedRepository;
import org.sonatype.nexus.yum.internal.capabilities.AliasMappingsValidator;
import org.sonatype.sisu.goodies.i18n.I18N;
import org.sonatype.sisu.goodies.i18n.MessageBundle;

@Singleton
@Named(value="yum.generate")
public class GenerateMetadataCapabilityDescriptor
extends CapabilityDescriptorSupport
implements Taggable {
    public static final String TYPE_ID = "yum.generate";
    public static final CapabilityType TYPE = CapabilityType.capabilityType((String)"yum.generate");
    private static final Messages messages = (Messages)I18N.create(Messages.class);
    private final List<FormField> formFields = Lists.newArrayList((Object[])new FormField[]{new RepositoryCombobox("repository", messages.repositoryLabel(), messages.repositoryHelp(), true).includingAnyOfFacets(new Class[]{MavenHostedRepository.class}), new TextAreaFormField("aliases", "Aliases", "Format: <alias>=<version>[,<alias>=<version>]", false), new CheckboxFormField("deleteProcessing", "Process deletes", "Check if removing an RPM from this repository should regenerate Yum repository (default true)", false).withInitialValue(Boolean.valueOf(true)), new NumberTextFormField("deleteProcessingDelay", "Delete process delay", "Number of seconds to wait before regenerating Yum repository when an RPM is removed (default 10 seconds)", false).withInitialValue((Number)10), new StringTextFormField("yumGroupsDefinitionFile", "Yum groups definition file", "Repository path of a file containing Yum groups definition (e.g. /comps.xml)", false)});

    @Inject
    public GenerateMetadataCapabilityDescriptor() {
    }

    public CapabilityType type() {
        return TYPE;
    }

    public String name() {
        return messages.name();
    }

    public List<FormField> formFields() {
        return this.formFields;
    }

    public Validator validator() {
        return this.validators().logical().and(new Validator[]{this.validators().repository().repositoryOfType(TYPE, "repository", MavenHostedRepository.class), this.validators().capability().uniquePer(TYPE, new String[]{"repository"}), new AliasMappingsValidator("aliases")});
    }

    public Validator validator(CapabilityIdentity id) {
        return this.validators().logical().and(new Validator[]{this.validators().repository().repositoryOfType(TYPE, "repository", MavenHostedRepository.class), this.validators().capability().uniquePerExcluding(id, TYPE, new String[]{"repository"}), new AliasMappingsValidator("aliases")});
    }

    protected String renderAbout() throws Exception {
        return this.render("yum.generate-about.vm");
    }

    public Set<Tag> getTags() {
        return Tag.tags((Tag[])new Tag[]{Tag.categoryTag((String)"Yum")});
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="Yum: Generate Metadata")
        public String name();

        @MessageBundle.DefaultMessage(value="Repository")
        public String repositoryLabel();

        @MessageBundle.DefaultMessage(value="Select the hosted repository for which Yum metadata should be generated")
        public String repositoryHelp();
    }
}

