/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.yum.internal.capabilities;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import org.sonatype.nexus.yum.internal.capabilities.AliasMappings;
import org.sonatype.nexus.yum.internal.capabilities.MetadataCapabilityConfigurationSupport;

public class GenerateMetadataCapabilityConfiguration
extends MetadataCapabilityConfigurationSupport {
    public static final String ALIASES = "aliases";
    public static final String DELETE_PROCESSING = "deleteProcessing";
    public static final String DELETE_PROCESSING_DELAY = "deleteProcessingDelay";
    public static final String YUM_GROUPS_DEFINITION_FILE = "yumGroupsDefinitionFile";
    private Map<String, String> aliases = Maps.newTreeMap();
    private boolean processDeletes;
    private long deleteProcessingDelay;
    private String yumGroupsDefinitionFile;

    public GenerateMetadataCapabilityConfiguration(String repository, Map<String, String> aliases, boolean processDeletes, long deleteProcessingDelay, String yumGroupsDefinitionFile) {
        super(repository);
        this.aliases.putAll((Map)Preconditions.checkNotNull(aliases));
        this.processDeletes = processDeletes;
        this.deleteProcessingDelay = deleteProcessingDelay;
        this.yumGroupsDefinitionFile = yumGroupsDefinitionFile;
    }

    public GenerateMetadataCapabilityConfiguration(Map<String, String> properties) {
        super(properties);
        this.aliases.putAll(new AliasMappings(properties.get(ALIASES)).aliases());
        boolean processDeletes = true;
        if (properties.containsKey(DELETE_PROCESSING)) {
            processDeletes = Boolean.parseBoolean(properties.get(DELETE_PROCESSING));
        }
        this.processDeletes = processDeletes;
        long deleteProcessingDelay = 10L;
        try {
            deleteProcessingDelay = Long.parseLong(properties.get(DELETE_PROCESSING_DELAY));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.deleteProcessingDelay = deleteProcessingDelay;
        this.yumGroupsDefinitionFile = properties.get(YUM_GROUPS_DEFINITION_FILE);
    }

    public Map<String, String> aliases() {
        return this.aliases;
    }

    public long deleteProcessingDelay() {
        return this.deleteProcessingDelay;
    }

    public boolean shouldProcessDeletes() {
        return this.processDeletes;
    }

    @Override
    public Map<String, String> asMap() {
        Map<String, String> props = super.asMap();
        props.put(ALIASES, new AliasMappings(this.aliases).toString());
        props.put(DELETE_PROCESSING, String.valueOf(this.processDeletes));
        props.put(DELETE_PROCESSING_DELAY, String.valueOf(this.deleteProcessingDelay));
        if (this.yumGroupsDefinitionFile != null) {
            props.put(YUM_GROUPS_DEFINITION_FILE, this.yumGroupsDefinitionFile);
        }
        return props;
    }

    public String getYumGroupsDefinitionFile() {
        return this.yumGroupsDefinitionFile;
    }
}

