/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.yum.internal.capabilities;

import com.google.common.base.Preconditions;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.proxy.registry.RepositoryRegistry;
import org.sonatype.nexus.yum.Yum;
import org.sonatype.nexus.yum.YumHosted;
import org.sonatype.nexus.yum.YumRegistry;
import org.sonatype.nexus.yum.internal.capabilities.GenerateMetadataCapabilityConfiguration;
import org.sonatype.nexus.yum.internal.capabilities.MetadataCapabilitySupport;

@Named(value="yum.generate")
public class GenerateMetadataCapability
extends MetadataCapabilitySupport<GenerateMetadataCapabilityConfiguration> {
    @Inject
    public GenerateMetadataCapability(YumRegistry yumRegistry, RepositoryRegistry repositoryRegistry) {
        super(yumRegistry, repositoryRegistry);
    }

    @Override
    void configureYum(Yum yum, GenerateMetadataCapabilityConfiguration config) {
        Preconditions.checkNotNull((Object)yum);
        Preconditions.checkState((boolean)this.isConfigured());
        Preconditions.checkArgument((boolean)(yum instanceof YumHosted), (Object)"Yum must be a YumHosted");
        ((YumHosted)yum).setAliases(config.aliases());
        ((YumHosted)yum).setProcessDeletes(config.shouldProcessDeletes());
        ((YumHosted)yum).setDeleteProcessingDelay(config.deleteProcessingDelay());
        ((YumHosted)yum).setYumGroupsDefinitionFile(config.getYumGroupsDefinitionFile());
    }

    protected GenerateMetadataCapabilityConfiguration createConfig(Map<String, String> properties) {
        return new GenerateMetadataCapabilityConfiguration(properties);
    }
}

