/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.yum.internal.capabilities;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.sonatype.nexus.plugins.capabilities.ValidationResult;
import org.sonatype.nexus.plugins.capabilities.Validator;
import org.sonatype.nexus.plugins.capabilities.support.validator.DefaultValidationResult;
import org.sonatype.nexus.yum.internal.capabilities.AliasMappings;

public class AliasMappingsValidator
implements Validator {
    private final String key;

    public AliasMappingsValidator(String key) {
        this.key = (String)Preconditions.checkNotNull((Object)key);
    }

    public ValidationResult validate(Map<String, String> properties) {
        try {
            new AliasMappings(properties.get(this.key));
            return ValidationResult.VALID;
        }
        catch (IllegalArgumentException e) {
            return new DefaultValidationResult().add(this.key, e.getMessage());
        }
    }

    public String explainValid() {
        return "Valid alias mappings";
    }

    public String explainInvalid() {
        return "Invalid alias mappings. Expected <alias>=<version> entries separated by comma (,)";
    }
}

