/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.yum.internal.capabilities;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.shiro.util.StringUtils;

public class AliasMappings {
    private Map<String, String> aliases;

    public AliasMappings(Map<String, String> aliases) {
        this.aliases = Maps.newTreeMap();
        this.aliases.putAll((Map)Preconditions.checkNotNull(aliases));
    }

    public AliasMappings(String mappings) {
        this.aliases = AliasMappings.parseAliases(mappings);
    }

    public Map<String, String> aliases() {
        return this.aliases;
    }

    public String toString() {
        return StringUtils.join(this.aliases.entrySet().iterator(), (String)",");
    }

    private static Map<String, String> parseAliases(String mappings) {
        HashMap parsedAliases = Maps.newHashMap();
        if (mappings != null && !mappings.trim().isEmpty()) {
            String[] segments;
            for (String segment : segments = mappings.split(",")) {
                if (segment.trim().isEmpty()) continue;
                String[] parts = segment.split("=");
                if (parts.length != 2) {
                    throw new IllegalArgumentException("Invalid format for entry '" + segment + "'. Expected <alias>=<version>");
                }
                parsedAliases.put(parts[0], parts[1]);
            }
        }
        return parsedAliases;
    }
}

