/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.yum.internal;

import java.io.File;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.yum.YumRepository;

public class YumRepositoryImpl
implements YumRepository {
    private static final Logger LOG = LoggerFactory.getLogger(YumRepositoryImpl.class);
    private final File baseDir;
    private boolean dirty = false;
    private final String version;
    private final String id;

    public YumRepositoryImpl(File baseDir, String repositoryId, String version) {
        this.baseDir = baseDir;
        this.id = repositoryId;
        this.version = version;
        if (LOG.isDebugEnabled()) {
            Object[] files = null;
            File repodata = new File(baseDir, "repodata");
            if (repodata.exists() && repodata.isDirectory()) {
                files = repodata.list();
            }
            LOG.debug("Yum repository {}/{} available at {} contains {}", new Object[]{repositoryId, version, repodata.getAbsolutePath(), files == null ? "no files" : Arrays.toString(files)});
        }
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    @Override
    public File resolvePath(String path) {
        return path == null || "/".equals(path) ? this.baseDir : new File(this.baseDir, path.trim());
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty() {
        this.dirty = true;
    }

    public String version() {
        return this.version;
    }

    public String nexusRepositoryId() {
        return this.id;
    }
}

