/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.yum.internal;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.sonatype.nexus.yum.internal.YumRepositoryImpl;

public class YumRepositoryCache {
    private final Map<String, YumRepositoryImpl> cache = new ConcurrentHashMap<String, YumRepositoryImpl>();

    public YumRepositoryImpl lookup(String id, String version) {
        YumRepositoryImpl yumRepository = this.cache.get(this.hash(id, version));
        if (yumRepository != null && !yumRepository.getBaseDir().exists()) {
            yumRepository.setDirty();
        }
        return yumRepository;
    }

    public void cache(YumRepositoryImpl yumRepository) {
        this.cache.put(this.hash(yumRepository.nexusRepositoryId(), yumRepository.version()), yumRepository);
    }

    public void markDirty(String id, String version) {
        YumRepositoryImpl repository = this.cache.get(this.hash(id, version));
        if (repository != null) {
            repository.setDirty();
        }
    }

    private String hash(String id, String version) {
        return id + "/" + version;
    }
}

