/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.yum.internal;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.configuration.application.NexusConfiguration;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.item.ContentLocator;
import org.sonatype.nexus.proxy.item.DefaultStorageFileItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.item.StringContentLocator;
import org.sonatype.nexus.proxy.maven.MavenRepository;
import org.sonatype.nexus.proxy.repository.GroupRepository;
import org.sonatype.nexus.proxy.repository.HostedRepository;
import org.sonatype.nexus.proxy.repository.ProxyRepository;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.scheduling.NexusScheduler;
import org.sonatype.nexus.yum.Yum;
import org.sonatype.nexus.yum.YumRegistry;
import org.sonatype.nexus.yum.internal.MergeMetadataRequestStrategy;
import org.sonatype.nexus.yum.internal.ProxyMetadataRequestStrategy;
import org.sonatype.nexus.yum.internal.YumConfigContentGenerator;
import org.sonatype.nexus.yum.internal.YumFactory;

@Named
@Singleton
public class YumRegistryImpl
implements YumRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(YumRegistryImpl.class);
    private final Map<String, Yum> yums = new ConcurrentHashMap<String, Yum>();
    private final NexusConfiguration nexusConfiguration;
    private final NexusScheduler nexusScheduler;
    private final YumFactory yumFactory;
    private int maxNumberOfParallelThreads;
    private String createrepoPath;
    private String mergerepoPath;

    @Inject
    public YumRegistryImpl(NexusConfiguration nexusConfiguration, NexusScheduler nexusScheduler, YumFactory yumFactory) {
        this.nexusConfiguration = (NexusConfiguration)Preconditions.checkNotNull((Object)nexusConfiguration);
        this.nexusScheduler = (NexusScheduler)Preconditions.checkNotNull((Object)nexusScheduler);
        this.yumFactory = (YumFactory)Preconditions.checkNotNull((Object)yumFactory);
        this.maxNumberOfParallelThreads = 10;
    }

    @Override
    public Yum register(MavenRepository repository) {
        if (!this.yums.containsKey(repository.getId())) {
            Yum yum;
            if (repository.getRepositoryKind().isFacetAvailable(HostedRepository.class)) {
                yum = this.yumFactory.createHosted(this.getTemporaryDirectory(), (HostedRepository)repository.adaptToFacet(HostedRepository.class));
            } else if (repository.getRepositoryKind().isFacetAvailable(ProxyRepository.class)) {
                yum = this.yumFactory.createProxy((ProxyRepository)repository.adaptToFacet(ProxyRepository.class));
            } else if (repository.getRepositoryKind().isFacetAvailable(GroupRepository.class)) {
                yum = this.yumFactory.createGroup((GroupRepository)repository.adaptToFacet(GroupRepository.class));
            } else {
                throw new IllegalArgumentException("Only hosted and groups are supported");
            }
            this.yums.put(repository.getId(), yum);
            LOG.info("Registered repository '{}' as Yum repository", (Object)repository.getId());
            this.createVirtualYumConfigFile(repository);
            return yum;
        }
        return this.yums.get(repository.getId());
    }

    @Override
    public Yum unregister(String repositoryId) {
        Yum yum = this.yums.remove(repositoryId);
        if (yum != null) {
            yum.getNexusRepository().unregisterRequestStrategy(ProxyMetadataRequestStrategy.class.getName());
            yum.getNexusRepository().unregisterRequestStrategy(MergeMetadataRequestStrategy.class.getName());
            LOG.info("Unregistered repository '{}' as Yum repository", (Object)repositoryId);
        }
        return yum;
    }

    @Override
    public Yum get(String repositoryId) {
        return this.yums.get(repositoryId);
    }

    @Override
    public boolean isRegistered(String repositoryId) {
        return this.yums.containsKey(repositoryId);
    }

    @Override
    public YumRegistry setMaxNumberOfParallelThreads(int maxNumberOfParallelThreads) {
        this.maxNumberOfParallelThreads = maxNumberOfParallelThreads;
        return this;
    }

    @Override
    public int maxNumberOfParallelThreads() {
        return this.maxNumberOfParallelThreads;
    }

    @Override
    public String getCreaterepoPath() {
        return StringUtils.isBlank((String)this.createrepoPath) ? "createrepo" : this.createrepoPath;
    }

    @Override
    public void setCreaterepoPath(String path) {
        this.createrepoPath = path;
    }

    @Override
    public String getMergerepoPath() {
        return StringUtils.isBlank((String)this.mergerepoPath) ? "mergerepo" : this.mergerepoPath;
    }

    @Override
    public void setMergerepoPath(String path) {
        this.mergerepoPath = path;
    }

    @Override
    public File getTemporaryDirectory() {
        return new File(this.nexusConfiguration.getTemporaryDirectory(), "nexus-yum-repository-plugin");
    }

    private void createVirtualYumConfigFile(MavenRepository repository) {
        DefaultStorageFileItem file = new DefaultStorageFileItem((Repository)repository, new ResourceStoreRequest(YumConfigContentGenerator.configFilePath(repository.getId())), true, false, (ContentLocator)new StringContentLocator("YumConfigContentGenerator"));
        file.setContentGeneratorId("YumConfigContentGenerator");
        try {
            repository.storeItem(false, (StorageItem)file);
        }
        catch (Exception e) {
            LOG.warn("Could not install yum.repo file '{}' due to {}/{}", new Object[]{file, e.getClass().getName(), e.getMessage()});
        }
    }
}

