/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.yum.internal;

import com.google.common.base.Preconditions;
import com.google.inject.assistedinject.Assisted;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.proxy.repository.ProxyRepository;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.repository.RequestStrategy;
import org.sonatype.nexus.yum.YumProxy;
import org.sonatype.nexus.yum.YumRepository;
import org.sonatype.nexus.yum.internal.BlockSqliteDatabasesRequestStrategy;
import org.sonatype.nexus.yum.internal.ProxyMetadataRequestStrategy;
import org.sonatype.nexus.yum.internal.RepositoryUtils;
import org.sonatype.nexus.yum.internal.YumRepositoryImpl;

@Named
public class YumProxyImpl
implements YumProxy {
    private final ProxyRepository repository;
    private final File baseDir;
    private final YumRepository yumRepository;

    @Inject
    public YumProxyImpl(ProxyMetadataRequestStrategy proxyMetadataRequestStrategy, BlockSqliteDatabasesRequestStrategy blockSqliteDatabasesRequestStrategy, @Assisted ProxyRepository repository) throws MalformedURLException, URISyntaxException {
        this.repository = (ProxyRepository)Preconditions.checkNotNull((Object)repository);
        this.baseDir = RepositoryUtils.getBaseDir((Repository)repository);
        this.yumRepository = new YumRepositoryImpl(this.baseDir, repository.getId(), null);
        repository.registerRequestStrategy(BlockSqliteDatabasesRequestStrategy.class.getName(), (RequestStrategy)Preconditions.checkNotNull((Object)((Object)blockSqliteDatabasesRequestStrategy)));
        repository.registerRequestStrategy(ProxyMetadataRequestStrategy.class.getName(), (RequestStrategy)Preconditions.checkNotNull((Object)((Object)proxyMetadataRequestStrategy)));
    }

    @Override
    public File getBaseDir() {
        return this.baseDir;
    }

    @Override
    public Repository getNexusRepository() {
        return this.repository;
    }

    @Override
    public YumRepository getYumRepository() {
        return this.yumRepository;
    }
}

