/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.yum.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.inject.assistedinject.Assisted;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.repository.HostedRepository;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.repository.RequestStrategy;
import org.sonatype.nexus.scheduling.NexusScheduler;
import org.sonatype.nexus.scheduling.NexusTask;
import org.sonatype.nexus.yum.YumHosted;
import org.sonatype.nexus.yum.YumRepository;
import org.sonatype.nexus.yum.internal.BlockSqliteDatabasesRequestStrategy;
import org.sonatype.nexus.yum.internal.RepositoryUtils;
import org.sonatype.nexus.yum.internal.YumRepositoryCache;
import org.sonatype.nexus.yum.internal.YumRepositoryImpl;
import org.sonatype.nexus.yum.internal.task.GenerateMetadataTask;
import org.sonatype.nexus.yum.internal.task.TaskAlreadyScheduledException;
import org.sonatype.scheduling.ScheduledTask;

@Named
public class YumHostedImpl
implements YumHosted {
    private static final Logger LOG = LoggerFactory.getLogger(YumHostedImpl.class);
    private static final int MAX_EXECUTION_COUNT = 100;
    private final NexusScheduler nexusScheduler;
    private final ScheduledThreadPoolExecutor executor;
    private final HostedRepository repository;
    private final File temporaryDirectory;
    private boolean processDeletes;
    private long deleteProcessingDelay;
    private String yumGroupsDefinitionFile;
    private final File baseDir;
    private final Map<String, String> aliases;
    private final Map<ScheduledFuture<?>, DelayedDirectoryDeletionTask> taskMap = new HashMap();
    private final Map<DelayedDirectoryDeletionTask, ScheduledFuture<?>> reverseTaskMap = new HashMap();
    private final YumRepositoryCache cache = new YumRepositoryCache();

    @Inject
    public YumHostedImpl(NexusScheduler nexusScheduler, ScheduledThreadPoolExecutor executor, BlockSqliteDatabasesRequestStrategy blockSqliteDatabasesRequestStrategy, @Assisted HostedRepository repository, @Assisted File temporaryDirectory) throws MalformedURLException, URISyntaxException {
        this.nexusScheduler = (NexusScheduler)Preconditions.checkNotNull((Object)nexusScheduler);
        this.executor = (ScheduledThreadPoolExecutor)Preconditions.checkNotNull((Object)executor);
        this.repository = (HostedRepository)Preconditions.checkNotNull((Object)repository);
        this.temporaryDirectory = (File)Preconditions.checkNotNull((Object)temporaryDirectory);
        this.processDeletes = true;
        this.deleteProcessingDelay = 10L;
        this.aliases = Maps.newHashMap();
        this.baseDir = RepositoryUtils.getBaseDir((Repository)repository);
        this.yumGroupsDefinitionFile = null;
        repository.registerRequestStrategy(BlockSqliteDatabasesRequestStrategy.class.getName(), (RequestStrategy)Preconditions.checkNotNull((Object)((Object)blockSqliteDatabasesRequestStrategy)));
    }

    @Override
    public YumHosted setProcessDeletes(boolean processDeletes) {
        this.processDeletes = processDeletes;
        return this;
    }

    @Override
    public YumHosted setDeleteProcessingDelay(long numberOfSeconds) {
        this.deleteProcessingDelay = numberOfSeconds;
        return this;
    }

    @Override
    public YumHosted setYumGroupsDefinitionFile(String yumGroupsDefinitionFile) {
        this.yumGroupsDefinitionFile = yumGroupsDefinitionFile;
        return this;
    }

    @Override
    public boolean shouldProcessDeletes() {
        return this.processDeletes;
    }

    @Override
    public long deleteProcessingDelay() {
        return this.deleteProcessingDelay;
    }

    @Override
    public String getYumGroupsDefinitionFile() {
        return this.yumGroupsDefinitionFile;
    }

    @Override
    public File getBaseDir() {
        return this.baseDir;
    }

    @Override
    public YumHosted addAlias(String alias, String version) {
        this.aliases.put(alias, version);
        return this;
    }

    @Override
    public YumHosted removeAlias(String alias) {
        this.aliases.remove(alias);
        return this;
    }

    @Override
    public YumHosted setAliases(Map<String, String> aliases) {
        this.aliases.clear();
        this.aliases.putAll(aliases);
        return this;
    }

    @Override
    public String getVersion(String alias) {
        return this.aliases.get(alias);
    }

    @Override
    public Repository getNexusRepository() {
        return this.repository;
    }

    @Override
    public YumRepository getYumRepository() throws Exception {
        return this.getYumRepository(null);
    }

    ScheduledTask<YumRepository> createYumRepository(String version, File yumRepoBaseDir) {
        try {
            File rpmBaseDir = RepositoryUtils.getBaseDir((Repository)this.repository);
            GenerateMetadataTask task = this.createTask();
            task.setRpmDir(rpmBaseDir.getAbsolutePath());
            task.setRepoDir(yumRepoBaseDir);
            task.setRepositoryId(this.repository.getId());
            task.setVersion(version);
            task.setYumGroupsDefinitionFile(this.getYumGroupsDefinitionFile());
            return this.submitTask(task);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create repository", e);
        }
    }

    @Override
    public YumRepository getYumRepository(String version) throws Exception {
        YumRepositoryImpl yumRepository = this.cache.lookup(this.repository.getId(), version);
        if (yumRepository == null || yumRepository.isDirty()) {
            ScheduledTask<YumRepository> future = this.createYumRepository(version, this.createRepositoryTempDir((Repository)this.repository, version));
            yumRepository = (YumRepositoryImpl)future.get();
            this.cache.cache(yumRepository);
        }
        return yumRepository;
    }

    private ScheduledTask<YumRepository> submitTask(GenerateMetadataTask task) {
        try {
            return this.nexusScheduler.submit("GenerateMetadataTask", (NexusTask)task);
        }
        catch (TaskAlreadyScheduledException e) {
            return this.mergeAddedFiles(e.getOriginal(), task);
        }
    }

    @Override
    public ScheduledTask<YumRepository> regenerate() {
        return this.addRpmAndRegenerate(null);
    }

    @Override
    public void markDirty(String version) {
        this.cache.markDirty(this.repository.getId(), version);
    }

    @Override
    public ScheduledTask<YumRepository> addRpmAndRegenerate(@Nullable String filePath) {
        try {
            LOG.debug("Processing added rpm {}:{}", (Object)this.repository.getId(), (Object)filePath);
            File rpmBaseDir = RepositoryUtils.getBaseDir((Repository)this.repository);
            GenerateMetadataTask task = this.createTask();
            task.setRpmDir(rpmBaseDir.getAbsolutePath());
            task.setRepositoryId(this.repository.getId());
            task.setAddedFiles(filePath);
            task.setYumGroupsDefinitionFile(this.getYumGroupsDefinitionFile());
            return this.submitTask(task);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create repository", e);
        }
    }

    private ScheduledTask<YumRepository> mergeAddedFiles(ScheduledTask<?> existingScheduledTask, GenerateMetadataTask taskToMerge) {
        if (StringUtils.isNotBlank((String)taskToMerge.getAddedFiles())) {
            GenerateMetadataTask existingTask = (GenerateMetadataTask)((Object)existingScheduledTask.getTask());
            if (StringUtils.isBlank((String)existingTask.getAddedFiles())) {
                existingTask.setAddedFiles(taskToMerge.getAddedFiles());
            } else {
                existingTask.setAddedFiles(existingTask.getAddedFiles() + File.pathSeparator + taskToMerge.getAddedFiles());
            }
        }
        return existingScheduledTask;
    }

    private GenerateMetadataTask createTask() {
        GenerateMetadataTask task = (GenerateMetadataTask)this.nexusScheduler.createTaskInstance(GenerateMetadataTask.class);
        if (task == null) {
            throw new IllegalStateException("Could not create a task fo type " + GenerateMetadataTask.class.getName());
        }
        return task;
    }

    private File createRepositoryTempDir(Repository repository, String version) {
        return new File(this.temporaryDirectory, repository.getId() + File.separator + version);
    }

    @Override
    public void regenerateWhenPathIsRemoved(String path) {
        if (this.shouldProcessDeletes()) {
            LOG.debug("Processing deleted rpm {}:{}", (Object)this.repository.getId(), (Object)path);
            if (this.findDelayedParentDirectory(path) == null) {
                this.regenerate();
            }
        }
    }

    @Override
    public void regenerateWhenDirectoryIsRemoved(String path) {
        if (this.shouldProcessDeletes()) {
            LOG.debug("Processing deleted dir {}:{}", (Object)this.repository.getId(), (Object)path);
            if (this.findDelayedParentDirectory(path) == null) {
                this.schedule(new DelayedDirectoryDeletionTask(path));
            }
        }
    }

    private void schedule(DelayedDirectoryDeletionTask task) {
        ScheduledFuture<?> future = this.executor.schedule(task, this.deleteProcessingDelay(), TimeUnit.SECONDS);
        this.taskMap.put(future, task);
        this.reverseTaskMap.put(task, future);
    }

    private DelayedDirectoryDeletionTask findDelayedParentDirectory(String path) {
        for (Runnable runnable : this.executor.getQueue()) {
            DelayedDirectoryDeletionTask dirTask = this.taskMap.get(runnable);
            if (dirTask == null || !path.startsWith(dirTask.path)) continue;
            return dirTask;
        }
        return null;
    }

    private boolean isDeleted(String path) {
        try {
            this.repository.retrieveItem(new ResourceStoreRequest(path));
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }

    private class DelayedDirectoryDeletionTask
    implements Runnable {
        private final String path;
        private int executionCount = 0;

        private DelayedDirectoryDeletionTask(String path) {
            this.path = path;
        }

        @Override
        public void run() {
            ++this.executionCount;
            ScheduledFuture future = (ScheduledFuture)YumHostedImpl.this.reverseTaskMap.remove(this);
            if (future != null) {
                YumHostedImpl.this.taskMap.remove(future);
            }
            if (YumHostedImpl.this.isDeleted(this.path)) {
                LOG.debug("Recreate yum repository {} because of removed path {}", (Object)YumHostedImpl.this.getNexusRepository().getId(), (Object)this.path);
                YumHostedImpl.this.regenerate();
            } else if (this.executionCount < 100) {
                LOG.debug("Rescheduling creation of yum repository {} because path {} not deleted.", (Object)YumHostedImpl.this.getNexusRepository().getId(), (Object)this.path);
                YumHostedImpl.this.schedule(this);
            } else {
                LOG.warn("Deleting path {} in repository {} took too long - retried {} times.", new Object[]{this.path, YumHostedImpl.this.getNexusRepository().getId(), 100});
            }
        }
    }
}

