/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.yum.internal;

import com.google.common.base.Preconditions;
import com.google.inject.assistedinject.Assisted;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.proxy.repository.GroupRepository;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.repository.RequestStrategy;
import org.sonatype.nexus.scheduling.NexusScheduler;
import org.sonatype.nexus.yum.YumGroup;
import org.sonatype.nexus.yum.YumRepository;
import org.sonatype.nexus.yum.internal.MergeMetadataRequestStrategy;
import org.sonatype.nexus.yum.internal.RepositoryUtils;
import org.sonatype.nexus.yum.internal.task.MergeMetadataTask;

@Named
public class YumGroupImpl
implements YumGroup {
    private static final Logger log = LoggerFactory.getLogger(YumGroupImpl.class);
    private final NexusScheduler nexusScheduler;
    private final GroupRepository repository;
    private final File baseDir;
    private final ReadWriteLock lock;
    private YumRepository yumRepository;

    @Inject
    public YumGroupImpl(NexusScheduler nexusScheduler, MergeMetadataRequestStrategy mergeMetadataRequestStrategy, @Assisted GroupRepository repository) throws MalformedURLException, URISyntaxException {
        this.nexusScheduler = (NexusScheduler)Preconditions.checkNotNull((Object)nexusScheduler);
        this.repository = (GroupRepository)Preconditions.checkNotNull((Object)repository);
        this.baseDir = RepositoryUtils.getBaseDir((Repository)repository);
        this.lock = new ReentrantReadWriteLock();
        repository.registerRequestStrategy(MergeMetadataRequestStrategy.class.getName(), (RequestStrategy)mergeMetadataRequestStrategy);
    }

    @Override
    public File getBaseDir() {
        return this.baseDir;
    }

    @Override
    public Repository getNexusRepository() {
        return this.repository;
    }

    @Override
    public YumRepository getYumRepository() throws Exception {
        this.lock.readLock().lock();
        try {
            if (this.yumRepository == null) {
                this.lock.readLock().unlock();
                this.lock.writeLock().lock();
                try {
                    if (this.yumRepository == null) {
                        this.yumRepository = (YumRepository)MergeMetadataTask.createTaskFor(this.nexusScheduler, this.repository).get();
                    }
                }
                finally {
                    this.lock.readLock().lock();
                    this.lock.writeLock().unlock();
                }
            }
            YumRepository yumRepository = this.yumRepository;
            return yumRepository;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void markDirty() {
        try {
            this.lock.writeLock().lock();
            this.yumRepository = null;
            log.debug("Marked {} as dirty.", (Object)this.repository.getId());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

