/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.yum.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.proxy.item.AbstractContentLocator;
import org.sonatype.nexus.proxy.item.ContentGenerator;
import org.sonatype.nexus.proxy.item.ContentLocator;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.rest.RepositoryURLBuilder;

@Named(value="YumConfigContentGenerator")
@Singleton
public class YumConfigContentGenerator
implements ContentGenerator {
    public static final String ID = "YumConfigContentGenerator";
    private RepositoryURLBuilder repositoryURLBuilder;

    @Inject
    public YumConfigContentGenerator(RepositoryURLBuilder repositoryURLBuilder) {
        this.repositoryURLBuilder = repositoryURLBuilder;
    }

    public String getGeneratorId() {
        return ID;
    }

    public ContentLocator generateContent(final Repository repository, String path, StorageFileItem item) {
        return new AbstractContentLocator("text/plain", true, -1L){
            private String content;

            public InputStream getContent() throws IOException {
                if (this.content == null) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    try (PrintWriter out = new PrintWriter(baos);){
                        out.println("[" + repository.getId() + "]");
                        out.println("name=" + repository.getName());
                        out.println("baseurl=" + YumConfigContentGenerator.this.repositoryURLBuilder.getExposedRepositoryContentUrl(repository, true));
                        out.println("enabled=1");
                        out.println("protect=0");
                        out.println("gpgcheck=0");
                        out.println("metadata_expire=30s");
                        out.println("autorefresh=1");
                        out.println("type=rpm-md");
                    }
                    this.content = new String(baos.toByteArray());
                }
                return new ByteArrayInputStream(this.content.getBytes("UTF-8"));
            }
        };
    }

    public static String configFilePath(String repositoryId) {
        return ".meta/" + repositoryId + ".repo";
    }
}

