/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.yum.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.FilenameUtils;
import org.sonatype.sisu.resource.scanner.Listener;
import org.sonatype.sisu.resource.scanner.Scanner;
import org.sonatype.sisu.resource.scanner.helper.ListenerSupport;

@Named
@Singleton
public class RpmScanner {
    private final Scanner scanner;

    @Inject
    public RpmScanner(@Named(value="serial") Scanner scanner) {
        this.scanner = (Scanner)Preconditions.checkNotNull((Object)scanner);
    }

    public Set<File> scan(final File baseDir) {
        final HashSet rpms = Sets.newHashSet();
        this.scanner.scan(baseDir, (Listener)new ListenerSupport(){

            public void onFile(File file) {
                if ("rpm".equalsIgnoreCase(FilenameUtils.getExtension((String)file.getName())) && !RpmScanner.getRelativePath(baseDir, file).startsWith(".")) {
                    rpms.add(file);
                }
            }
        });
        return rpms;
    }

    static String getRelativePath(File baseDir, File file) {
        String baseDirPath = baseDir.getAbsolutePath() + (baseDir.isDirectory() ? File.separator : "");
        String filePath = file.getAbsolutePath() + (file.isDirectory() ? File.separator : "");
        if (filePath.startsWith(baseDirPath)) {
            filePath = filePath.substring(baseDirPath.length());
        }
        return filePath;
    }
}

