/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.yum.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.yum.internal.ListFileFactory;
import org.sonatype.nexus.yum.internal.RpmScanner;

public class RpmListWriter {
    private static final int POSITION_AFTER_SLASH = 1;
    private static final Logger LOG = LoggerFactory.getLogger(RpmListWriter.class);
    private final File rpmListFile;
    private final String version;
    private final String addedFiles;
    private final File baseRpmDir;
    private final boolean singleRpmPerDirectory;
    private final boolean forceFullScan;
    private final ListFileFactory fileFactory;
    private final RpmScanner scanner;

    public RpmListWriter(File baseRpmDir, String addedFiles, String version, boolean singleRpmPerDirectory, boolean forceFullScan, ListFileFactory fileFactory, RpmScanner scanner) {
        this.baseRpmDir = baseRpmDir;
        this.addedFiles = addedFiles;
        this.version = version;
        this.singleRpmPerDirectory = singleRpmPerDirectory;
        this.forceFullScan = forceFullScan;
        this.fileFactory = fileFactory;
        this.scanner = scanner;
        this.rpmListFile = fileFactory.getRpmListFile();
    }

    public File writeList() throws IOException {
        if (this.rpmListFile.exists() && !this.forceFullScan) {
            LOG.debug("Reuse existing rpm list file : {}", (Object)this.rpmListFile);
            List<String> rpmFileList = this.pruneToExistingRpms();
            if (StringUtils.isNotBlank((String)this.version)) {
                return this.extractVersionOfListFile(rpmFileList);
            }
            if (StringUtils.isNotBlank((String)this.addedFiles)) {
                this.addNewlyAddedRpmFileToList(rpmFileList);
            }
            this.writeRpmFileList(rpmFileList);
        } else {
            this.rewriteList();
        }
        return this.rpmListFile;
    }

    private File extractVersionOfListFile(List<String> files) throws IOException {
        ArrayList<String> filesWithRequiredVersion = new ArrayList<String>();
        for (String file : files) {
            if (!this.hasRequiredVersion(file)) continue;
            filesWithRequiredVersion.add(file);
        }
        File rpmVersionedListFile = this.fileFactory.getRpmListFile(this.version);
        this.writeRpmFileList(filesWithRequiredVersion, rpmVersionedListFile);
        return rpmVersionedListFile;
    }

    private boolean hasRequiredVersion(String file) {
        String[] segments = file.split("\\/");
        return segments.length >= 2 && this.version.equals(segments[segments.length - 2]);
    }

    private void addNewlyAddedRpmFileToList(List<String> fileList) throws IOException {
        String[] filenames;
        for (String filename : filenames = this.addedFiles.split(File.pathSeparator)) {
            filename = this.addFileToList(fileList, filename);
        }
    }

    private String addFileToList(List<String> fileList, String filename) {
        int startPosition = filename.startsWith("/") ? 1 : 0;
        if (!fileList.contains(filename = filename.substring(startPosition))) {
            fileList.add(filename);
            LOG.debug("Added rpm {} to file list.", (Object)filename);
        } else {
            LOG.debug("Rpm {} already exists in file list.", (Object)filename);
        }
        return filename;
    }

    private List<String> pruneToExistingRpms() throws IOException {
        List<String> files = this.readRpmFileList();
        for (int i = 0; i < files.size(); ++i) {
            if (new File(this.baseRpmDir, files.get(i)).exists()) continue;
            LOG.debug("Removed {} from rpm list.", (Object)files.get(i));
            files.remove(i);
            --i;
        }
        return files;
    }

    private void writeRpmFileList(Collection<String> files) throws IOException {
        this.writeRpmFileList(files, this.rpmListFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRpmFileList(Collection<String> files, File rpmListOutputFile) throws IOException {
        try (FileOutputStream outputStream = new FileOutputStream(rpmListOutputFile);){
            IOUtils.writeLines(files, (String)"\n", (OutputStream)outputStream);
            if (files.isEmpty()) {
                LOG.debug("Write non existing package to rpm list file {} to avoid an empty packge list that would cause createrepo to scan the whole directory", (Object)rpmListOutputFile);
                IOUtils.write((String)".foo/.bar.rpm/to-avoid-an-empty-rpm-list-file/that-would-cause-createrepo-to-scan-the-whole-repo.rpm", (OutputStream)outputStream);
            } else {
                LOG.debug("Wrote {} rpm packages to rpm list file {} .", (Object)files.size(), (Object)rpmListOutputFile);
            }
        }
    }

    private List<String> readRpmFileList() throws IOException {
        try (FileInputStream inputStream = new FileInputStream(this.rpmListFile);){
            List list = IOUtils.readLines((InputStream)inputStream);
            return list;
        }
    }

    private void rewriteList() throws IOException {
        if (this.singleRpmPerDirectory) {
            this.rewriteFileList(this.getSortedFilteredFileList());
        } else {
            this.writeRpmFileList(this.getRelativeFilenames(this.scanner.scan(this.baseRpmDir)), this.rpmListFile);
        }
    }

    private List<String> getRelativeFilenames(Collection<File> rpmFileList) {
        ArrayList<String> result = new ArrayList<String>(rpmFileList.size());
        for (File rpmFile : rpmFileList) {
            result.add(RpmScanner.getRelativePath(this.baseRpmDir, rpmFile));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rewriteFileList(Map<String, String> fileMap) throws IOException {
        try (FileWriter writer = new FileWriter(this.rpmListFile);){
            for (Map.Entry<String, String> entry : fileMap.entrySet()) {
                ((Writer)writer).append(String.format("%s%s\n", entry.getKey(), entry.getValue()));
            }
        }
        LOG.debug("Wrote temporary package list to {}", (Object)this.rpmListFile.getAbsoluteFile());
    }

    private Map<String, String> getSortedFilteredFileList() {
        String absoluteBasePath = this.baseRpmDir + File.separator;
        TreeMap<String, String> fileMap = new TreeMap<String, String>();
        for (File file : this.scanner.scan(this.baseRpmDir)) {
            File parentFile = file.getParentFile();
            if (!this.matchesRequestedVersion(parentFile)) continue;
            String parentDir = RpmScanner.getRelativePath(this.baseRpmDir, parentFile);
            this.putLatestArtifactInMap(parentDir, file.getName(), fileMap);
        }
        return fileMap;
    }

    private void putLatestArtifactInMap(String parentDir, String filename, Map<String, String> fileMap) {
        if (!fileMap.containsKey(parentDir) || filename.compareTo(fileMap.get(parentDir)) > 0) {
            fileMap.put(parentDir, filename);
        }
    }

    private boolean matchesRequestedVersion(File parentFile) {
        return this.version == null || parentFile.getName().equals(this.version);
    }
}

