/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.yum.internal;

import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;

public class RepoMD {
    private final Map<String, String> locations;

    public RepoMD(InputStream in) {
        this.locations = RepoMD.parse(in);
    }

    private static Map<String, String> parse(InputStream in) {
        try {
            HashMap locations = Maps.newHashMap();
            Xpp3Dom dom = Xpp3DomBuilder.build((Reader)new XmlStreamReader(in));
            for (Xpp3Dom data : dom.getChildren("data")) {
                Xpp3Dom location = data.getChild("location");
                String type = data.getAttribute("type");
                String href = location.getAttribute("href");
                locations.put(type, href);
            }
            return locations;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public Collection<String> getLocations() {
        return this.locations.values();
    }

    public String getLocation(String type) {
        return this.locations.get(type);
    }
}

