/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.yum.internal;

import com.google.common.base.Throwables;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.access.Action;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.repository.AbstractRequestStrategy;
import org.sonatype.nexus.proxy.repository.ProxyRepository;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.yum.internal.MetadataProcessor;

@Named
@Singleton
public class ProxyMetadataRequestStrategy
extends AbstractRequestStrategy {
    private static final Logger log = LoggerFactory.getLogger(ProxyMetadataRequestStrategy.class);
    private static final String REPOMD_XML_PATH = "/repodata/repomd.xml";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onHandle(Repository repository, ResourceStoreRequest request, Action action) {
        block8: {
            if (action.isReadAction() && request.getRequestPath().startsWith(REPOMD_XML_PATH)) {
                try {
                    log.trace("Checking if {}:{} should be processed", (Object)repository.getId(), (Object)request.getRequestPath());
                    StorageFileItem repoMDItem = (StorageFileItem)repository.retrieveItem(false, new ResourceStoreRequest(REPOMD_XML_PATH));
                    if (repoMDItem.getRepositoryItemAttributes().get("yum.processed") != null) break block8;
                    try {
                        repoMDItem.getRepositoryItemUid().getLock().lock(Action.update);
                        if (repoMDItem.getRepositoryItemAttributes().get("yum.processed") == null) {
                            MetadataProcessor.processProxiedMetadata((ProxyRepository)repository);
                            repoMDItem.getRepositoryItemAttributes().put("yum.processed", String.valueOf(System.currentTimeMillis()));
                            repository.getAttributesHandler().storeAttributes((StorageItem)repoMDItem);
                        }
                    }
                    finally {
                        repoMDItem.getRepositoryItemUid().getLock().unlock();
                    }
                }
                catch (ItemNotFoundException repoMDItem) {
                }
                catch (Exception e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        }
    }
}

