/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.yum.internal;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.io.CountingInputStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.item.ContentLocator;
import org.sonatype.nexus.proxy.item.DefaultStorageFileItem;
import org.sonatype.nexus.proxy.item.PreparedContentLocator;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.repository.ProxyRepository;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.util.DigesterUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MetadataProcessor {
    private static final Logger log = LoggerFactory.getLogger(MetadataProcessor.class);

    private MetadataProcessor() {
    }

    public static boolean processMergedMetadata(Repository repository, final List<File> memberRepositoriesBaseDirs) {
        log.debug("Checking if {}:primary.xml locations should be rewritten after merge", (Object)repository.getId());
        return MetadataProcessor.processMetadata(repository, new Processor(){

            @Override
            public boolean process(Element location) {
                String xmlBase = location.getAttribute("xml:base");
                if (xmlBase != null) {
                    String href = location.getAttribute("href");
                    if (!xmlBase.endsWith("/")) {
                        xmlBase = xmlBase + "/";
                    }
                    href = xmlBase + href;
                    for (File memberReposBaseDir : memberRepositoriesBaseDirs) {
                        String memberRepoDirPath = memberReposBaseDir.getPath();
                        int pos = href.indexOf(memberRepoDirPath);
                        if (pos <= -1) continue;
                        if ((href = href.substring(pos + memberRepoDirPath.length())).startsWith("/")) {
                            href = href.substring(1);
                        }
                        location.setAttribute("href", href);
                        location.removeAttribute("xml:base");
                        return true;
                    }
                }
                return false;
            }
        });
    }

    public static boolean processProxiedMetadata(ProxyRepository repository) {
        log.debug("Checking if {}:primary.xml locations should be rewritten after being proxied", (Object)repository.getId());
        final String repositoryUrl = repository.getRemoteUrl();
        return MetadataProcessor.processMetadata((Repository)repository, new Processor(){

            @Override
            public boolean process(Element location) {
                String xmlBase = location.getAttribute("xml:base");
                if (xmlBase != null) {
                    String href = location.getAttribute("href");
                    if (!xmlBase.endsWith("/")) {
                        xmlBase = xmlBase + "/";
                    }
                    if ((href = xmlBase + href).startsWith(repositoryUrl)) {
                        if ((href = href.substring(repositoryUrl.length())).startsWith("/")) {
                            href = href.substring(1);
                        }
                        location.setAttribute("href", href);
                        location.removeAttribute("xml:base");
                        return true;
                    }
                }
                return false;
            }
        });
    }

    private static boolean processMetadata(Repository repository, Processor processor) {
        try {
            Document repoMDDoc = MetadataProcessor.parseRepoMD(repository);
            String primaryHref = MetadataProcessor.processPrimary(repository, processor, repoMDDoc);
            boolean changed = MetadataProcessor.updatePrimaryInRepoMD(repository, repoMDDoc, primaryHref);
            boolean bl = changed = MetadataProcessor.removeSqliteFromRepoMD(repository, repoMDDoc) || changed;
            if (changed) {
                MetadataProcessor.storeRepoMD(repository, repoMDDoc);
            }
            return changed;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static String processPrimary(Repository repository, Processor processor, Document repoMDDoc) throws Exception {
        Document doc;
        XPath xPath = XPathFactory.newInstance().newXPath();
        String primaryHref = xPath.compile("/repomd/data[@type='primary']/location/@href").evaluate(repoMDDoc);
        String primaryChecksum = xPath.compile("/repomd/data[@type='primary']/checksum").evaluate(repoMDDoc);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        StorageFileItem primaryItem = (StorageFileItem)repository.retrieveItem(false, new ResourceStoreRequest("/" + primaryHref));
        boolean changed = false;
        try (GZIPInputStream primaryIn = new GZIPInputStream(new BufferedInputStream(primaryItem.getInputStream()));){
            doc = documentBuilder.parse(primaryIn);
            NodeList locations = doc.getElementsByTagName("location");
            if (locations != null) {
                for (int i = 0; i < locations.getLength(); ++i) {
                    Element location = (Element)locations.item(i);
                    if (!processor.process(location)) continue;
                    changed = true;
                }
            }
        }
        if (changed) {
            log.debug("Rewriting locations in {}:primary.xml", (Object)repository.getId());
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            transformer.transform(new DOMSource(doc), new StreamResult(out));
            byte[] primaryContent = MetadataProcessor.compress(out.toByteArray());
            if (primaryHref.contains(primaryChecksum)) {
                repository.deleteItem(false, new ResourceStoreRequest("/" + primaryHref));
                primaryHref = primaryHref.replace(primaryChecksum, DigesterUtils.getDigest((String)"SHA-256", (InputStream)new ByteArrayInputStream(primaryContent)));
            }
            MetadataProcessor.storeItem(repository, primaryHref, primaryContent, "application/x-gzip");
        }
        return primaryHref;
    }

    private static boolean updatePrimaryInRepoMD(Repository repository, Document repoMDDoc, String primaryPath) throws Exception {
        XPath xPath = XPathFactory.newInstance().newXPath();
        String primaryHref = xPath.compile("/repomd/data[@type='primary']/location/@href").evaluate(repoMDDoc);
        if (!Objects.equals(primaryPath, primaryHref)) {
            Throwable throwable;
            CountingInputStream cis;
            log.debug("Updating 'primary' data entry in {}:repomd.xml", (Object)repository.getId());
            Element primaryEl = (Element)xPath.compile("/repomd/data[@type='primary']").evaluate(repoMDDoc, XPathConstants.NODE);
            StorageFileItem primaryItem = (StorageFileItem)repository.retrieveItem(false, new ResourceStoreRequest("/" + primaryPath));
            try (InputStream in = primaryItem.getInputStream();){
                cis = new CountingInputStream((InputStream)new GZIPInputStream(new BufferedInputStream(in)));
                throwable = null;
                try {
                    primaryEl.getElementsByTagName("open-checksum").item(0).setTextContent(String.valueOf(DigesterUtils.getDigest((String)"SHA-256", (InputStream)cis)));
                    primaryEl.getElementsByTagName("open-size").item(0).setTextContent(String.valueOf(cis.getCount()));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (cis != null) {
                        if (throwable != null) {
                            try {
                                cis.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            cis.close();
                        }
                    }
                }
            }
            primaryItem = (StorageFileItem)repository.retrieveItem(false, new ResourceStoreRequest("/" + primaryPath));
            in = primaryItem.getInputStream();
            var8_8 = null;
            try {
                cis = new CountingInputStream((InputStream)new BufferedInputStream(in));
                throwable = null;
                try {
                    primaryEl.getElementsByTagName("checksum").item(0).setTextContent(String.valueOf(DigesterUtils.getDigest((String)"SHA-256", (InputStream)cis)));
                    primaryEl.getElementsByTagName("size").item(0).setTextContent(String.valueOf(cis.getCount()));
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (cis != null) {
                        if (throwable != null) {
                            try {
                                cis.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            cis.close();
                        }
                    }
                }
            }
            catch (Throwable throwable6) {
                var8_8 = throwable6;
                throw throwable6;
            }
            finally {
                if (in != null) {
                    if (var8_8 != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable7) {
                            var8_8.addSuppressed(throwable7);
                        }
                    } else {
                        in.close();
                    }
                }
            }
            ((Element)primaryEl.getElementsByTagName("location").item(0)).setAttribute("href", primaryPath);
            return true;
        }
        return false;
    }

    private static boolean removeSqliteFromRepoMD(Repository repository, Document repoMDDoc) throws Exception {
        boolean changed = false;
        ArrayList elementsToRemove = Lists.newArrayList();
        NodeList dataNodes = repoMDDoc.getElementsByTagName("data");
        for (int i = 0; i < dataNodes.getLength(); ++i) {
            Element data = (Element)dataNodes.item(i);
            if (!data.getAttribute("type").endsWith("_db")) continue;
            elementsToRemove.add(data);
            changed = true;
        }
        if (changed) {
            log.debug("Removing sqllite from {}:repomd.xml", (Object)repository.getId());
            for (Element element : elementsToRemove) {
                element.getParentNode().removeChild(element);
            }
        }
        return changed;
    }

    private static void storeRepoMD(Repository repository, Document repoMDDoc) throws Exception {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        transformer.transform(new DOMSource(repoMDDoc), new StreamResult(out));
        MetadataProcessor.storeItem(repository, "repodata/repomd.xml", out.toByteArray(), "application/xml");
    }

    private static void storeItem(Repository repository, String path, byte[] content, String mimeType) throws Exception {
        log.debug("Storing {}:{}", (Object)repository.getId(), (Object)path);
        DefaultStorageFileItem item = new DefaultStorageFileItem(repository, new ResourceStoreRequest("/" + path), true, true, (ContentLocator)new PreparedContentLocator((InputStream)new ByteArrayInputStream(content), mimeType, -1L));
        repository.storeItem(false, (StorageItem)item);
    }

    private static byte[] compress(byte[] bytes) throws Exception {
        byte[] primaryCompressedBytes;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             GZIPOutputStream gzos = new GZIPOutputStream(baos);){
            IOUtils.copy((InputStream)new ByteArrayInputStream(bytes), (OutputStream)gzos);
            ((OutputStream)gzos).close();
            primaryCompressedBytes = baos.toByteArray();
        }
        return primaryCompressedBytes;
    }

    private static Document parseRepoMD(Repository repository) throws Exception {
        StorageFileItem repoMDItem = (StorageFileItem)repository.retrieveItem(false, new ResourceStoreRequest("/repodata/repomd.xml"));
        try (InputStream in = repoMDItem.getInputStream();){
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(in);
            return document;
        }
    }

    private static interface Processor {
        public boolean process(Element var1);
    }
}

