/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.yum.internal;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.access.Action;
import org.sonatype.nexus.proxy.repository.AbstractRequestStrategy;
import org.sonatype.nexus.proxy.repository.GroupRepository;
import org.sonatype.nexus.proxy.repository.ProxyRepository;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.repository.RequestStrategy;
import org.sonatype.nexus.yum.Yum;
import org.sonatype.nexus.yum.YumGroup;
import org.sonatype.nexus.yum.YumRegistry;

@Named
@Singleton
public class MergeMetadataRequestStrategy
extends AbstractRequestStrategy
implements RequestStrategy {
    private static final Logger log = LoggerFactory.getLogger(MergeMetadataRequestStrategy.class);
    private static final String PATH_OF_REPOMD_XML = "/repodata/repomd.xml";
    private final YumRegistry yumRegistry;

    @Inject
    public MergeMetadataRequestStrategy(YumRegistry yumRegistry) {
        this.yumRegistry = (YumRegistry)Preconditions.checkNotNull((Object)yumRegistry);
    }

    public void onHandle(Repository repository, ResourceStoreRequest request, Action action) throws ItemNotFoundException {
        Yum yum;
        GroupRepository groupRepository = (GroupRepository)repository.adaptToFacet(GroupRepository.class);
        String requestPath = request.getRequestPath();
        if (Action.read.equals((Object)action) && requestPath.endsWith(PATH_OF_REPOMD_XML) && groupRepository != null && (yum = this.yumRegistry.get(groupRepository.getId())) != null && yum instanceof YumGroup) {
            for (Repository member : groupRepository.getMemberRepositories()) {
                if (!member.getRepositoryKind().isFacetAvailable(ProxyRepository.class)) continue;
                try {
                    log.debug("Fetching {}:{} member of {}", new Object[]{member.getId(), PATH_OF_REPOMD_XML, groupRepository.getId()});
                    member.retrieveItem(new ResourceStoreRequest(PATH_OF_REPOMD_XML));
                }
                catch (ItemNotFoundException itemNotFoundException) {
                }
                catch (Exception e) {
                    log.debug("Could not retrieve {} from {}, member of yum enabled group {}. Ignoring.", new Object[]{PATH_OF_REPOMD_XML, member.getId(), groupRepository.getId(), e});
                }
            }
            try {
                yum.getYumRepository();
            }
            catch (Exception e) {
                throw new ItemNotFoundException((ItemNotFoundException.ItemNotFoundReason)ItemNotFoundException.reasonFor((ResourceStoreRequest)request, (Repository)repository, (String)e.getMessage(), (Object[])new Object[0]));
            }
        }
    }
}

