/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.yum.internal;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.eclipse.sisu.EagerSingleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.events.RepositoryGroupMembersChangedEvent;
import org.sonatype.nexus.proxy.events.RepositoryItemEvent;
import org.sonatype.nexus.proxy.events.RepositoryItemEventCache;
import org.sonatype.nexus.proxy.events.RepositoryItemEventDelete;
import org.sonatype.nexus.proxy.events.RepositoryItemEventStore;
import org.sonatype.nexus.proxy.item.StorageCollectionItem;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.item.uid.IsHiddenAttribute;
import org.sonatype.nexus.proxy.registry.RepositoryRegistry;
import org.sonatype.nexus.proxy.repository.GroupRepository;
import org.sonatype.nexus.proxy.repository.ProxyRepository;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.walker.AbstractFileWalkerProcessor;
import org.sonatype.nexus.proxy.walker.DefaultWalkerContext;
import org.sonatype.nexus.proxy.walker.Walker;
import org.sonatype.nexus.proxy.walker.WalkerContext;
import org.sonatype.nexus.proxy.walker.WalkerException;
import org.sonatype.nexus.yum.Yum;
import org.sonatype.nexus.yum.YumGroup;
import org.sonatype.nexus.yum.YumHosted;
import org.sonatype.nexus.yum.YumRegistry;
import org.sonatype.nexus.yum.internal.RepoMD;
import org.sonatype.sisu.goodies.eventbus.EventBus;

@Named
@EagerSingleton
public class EventsRouter {
    private static final Logger log = LoggerFactory.getLogger(EventsRouter.class);
    private final Provider<RepositoryRegistry> repositoryRegistryProvider;
    private final Provider<YumRegistry> yumRegistryProvider;
    private final Provider<Walker> walkerProvider;

    @Inject
    public EventsRouter(Provider<RepositoryRegistry> repositoryRegistryProvider, Provider<YumRegistry> yumRegistryProvider, Provider<Walker> walkerProvider, EventBus eventBus) {
        this.repositoryRegistryProvider = (Provider)Preconditions.checkNotNull(repositoryRegistryProvider);
        this.yumRegistryProvider = (Provider)Preconditions.checkNotNull(yumRegistryProvider);
        this.walkerProvider = (Provider)Preconditions.checkNotNull(walkerProvider);
        ((EventBus)Preconditions.checkNotNull((Object)eventBus)).register((Object)this);
    }

    @AllowConcurrentEvents
    @Subscribe
    public void on(RepositoryGroupMembersChangedEvent event) {
        Yum yum;
        if (((YumRegistry)this.yumRegistryProvider.get()).isRegistered(event.getGroupRepository().getId()) && (this.anyOfRepositoriesHasYumRepository(event.getAddedRepositoryIds()) || this.anyOfRepositoriesHasYumRepository(event.getRemovedRepositoryIds()) || this.anyOfRepositoriesHasYumRepository(event.getReorderedRepositoryIds())) && (yum = ((YumRegistry)this.yumRegistryProvider.get()).get(event.getGroupRepository().getId())) instanceof YumGroup) {
            ((YumGroup)yum).markDirty();
        }
    }

    @AllowConcurrentEvents
    @Subscribe
    public void on(RepositoryItemEventStore eventStore) {
        Yum yum;
        if (this.isRpmItemEvent((RepositoryItemEvent)eventStore) && (yum = ((YumRegistry)this.yumRegistryProvider.get()).get(eventStore.getRepository().getId())) != null && yum instanceof YumHosted) {
            ((YumHosted)yum).markDirty(this.getItemVersion(eventStore.getItem()));
            ((YumHosted)yum).addRpmAndRegenerate(eventStore.getItem().getPath());
        }
    }

    @AllowConcurrentEvents
    @Subscribe
    public void on(RepositoryItemEventDelete itemEvent) {
        Yum yum = ((YumRegistry)this.yumRegistryProvider.get()).get(itemEvent.getRepository().getId());
        if (yum != null && yum instanceof YumHosted) {
            if (this.isRpmItemEvent((RepositoryItemEvent)itemEvent)) {
                ((YumHosted)yum).regenerateWhenPathIsRemoved(itemEvent.getItem().getPath());
            } else if (this.isCollectionItem((RepositoryItemEvent)itemEvent)) {
                ((YumHosted)yum).regenerateWhenDirectoryIsRemoved(itemEvent.getItem().getPath());
            }
        }
    }

    @AllowConcurrentEvents
    @Subscribe
    public void on(RepositoryItemEventCache itemEvent) {
        final ProxyRepository repository = (ProxyRepository)itemEvent.getRepository().adaptToFacet(ProxyRepository.class);
        StorageItem item = itemEvent.getItem();
        if (repository != null && item.getPath().toLowerCase().equals("/repodata/repomd.xml")) {
            try {
                log.debug("Resetting processed flag... ({}:{} cached)", (Object)repository.getId(), (Object)item.getPath());
                item.getRepositoryItemAttributes().remove("yum.processed");
                repository.getAttributesHandler().storeAttributes(item);
            }
            catch (IOException e) {
                log.warn("Failed to reset processing flag for {}:{}", new Object[]{repository.getId(), item.getPath(), e});
            }
            log.debug("Marking group repositories as dirty... ({}:{} cached)", (Object)repository.getId(), (Object)item.getPath());
            List groups = ((RepositoryRegistry)this.repositoryRegistryProvider.get()).getGroupsOfRepository((Repository)repository);
            for (GroupRepository group : groups) {
                Yum yum = ((YumRegistry)this.yumRegistryProvider.get()).get(group.getId());
                if (yum == null || !(yum instanceof YumGroup)) continue;
                ((YumGroup)yum).markDirty();
            }
            try {
                log.debug("Removing obsolete metadata files... ({}:{} cached)", (Object)repository.getId(), (Object)item.getPath());
                RepoMD repoMD = new RepoMD(((StorageFileItem)item).getInputStream());
                final Collection<String> locations = repoMD.getLocations();
                ResourceStoreRequest request = new ResourceStoreRequest("/repodata", true, false);
                request.getRequestContext().put("request.authorized", (Object)Boolean.TRUE);
                DefaultWalkerContext context = new DefaultWalkerContext((Repository)repository, request);
                context.getProcessors().add(new AbstractFileWalkerProcessor(){

                    protected void processFileItem(WalkerContext context, StorageFileItem item) throws Exception {
                        if (!item.getPath().equals("/repodata/repomd.xml") && !locations.contains(item.getPath().substring(1))) {
                            log.trace("Removing obsolete {}:{}", (Object)repository.getId(), (Object)item.getPath());
                            repository.deleteItem(true, item.getResourceStoreRequest());
                        }
                    }
                });
                ((Walker)this.walkerProvider.get()).walk((WalkerContext)context);
            }
            catch (WalkerException e) {
                Throwable stopCause = e.getWalkerContext().getStopCause();
                if (!(stopCause instanceof ItemNotFoundException)) {
                    if (stopCause != null) {
                        log.warn("Failed to clean proxy YUM metadata", stopCause);
                    } else {
                        log.warn("Failed to clean proxy YUM metadata", (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                log.warn("Failed to clean proxy YUM metadata", (Throwable)e);
            }
        }
    }

    private boolean isCollectionItem(RepositoryItemEvent itemEvent) {
        return StorageCollectionItem.class.isAssignableFrom(itemEvent.getItem().getClass());
    }

    private boolean isRpmItemEvent(RepositoryItemEvent itemEvent) {
        return ((YumRegistry)this.yumRegistryProvider.get()).isRegistered(itemEvent.getRepository().getId()) && !itemEvent.getItem().getRepositoryItemUid().getBooleanAttributeValue(IsHiddenAttribute.class) && itemEvent.getItem().getPath().toLowerCase().endsWith(".rpm");
    }

    private String getItemVersion(StorageItem item) {
        String[] parts = item.getParentPath().split("/");
        return parts[parts.length - 1];
    }

    private boolean anyOfRepositoriesHasYumRepository(List<String> repositoryIds) {
        if (repositoryIds != null) {
            for (String repositoryId : repositoryIds) {
                try {
                    ((RepositoryRegistry)this.repositoryRegistryProvider.get()).getRepository(repositoryId).retrieveItem(new ResourceStoreRequest("repodata/repomd.xml"));
                    return true;
                }
                catch (Exception exception) {
                }
            }
        }
        return false;
    }
}

