/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.micromailer.imp;

import javax.inject.Named;
import javax.inject.Singleton;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;
import org.sonatype.micromailer.EmailerConfiguration;
import org.sonatype.micromailer.MailCompositionAttachmentException;
import org.sonatype.micromailer.MailCompositionMessagingException;
import org.sonatype.micromailer.MailRequest;
import org.sonatype.micromailer.MailSender;
import org.sonatype.micromailer.MailType;

@Singleton
@Named
public class DefaultMailSender
implements MailSender {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMail(EmailerConfiguration configuration, MailRequest request, MailType mailType) throws MailCompositionAttachmentException, MailCompositionMessagingException {
        try {
            Session session = configuration.getSession();
            MimeMessage message = request.getMimeMessage();
            message.saveChanges();
            Transport t = session.getTransport();
            try {
                t.connect();
                t.sendMessage((Message)message, message.getAllRecipients());
            }
            finally {
                t.close();
            }
        }
        catch (MessagingException ex) {
            throw new MailCompositionMessagingException("MessagingException occurred!", ex);
        }
    }
}

