/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.micromailer.imp;

import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.sonatype.micromailer.Address;
import org.sonatype.micromailer.EmailerConfiguration;
import org.sonatype.micromailer.MailComposer;
import org.sonatype.micromailer.MailCompositionAttachmentException;
import org.sonatype.micromailer.MailCompositionMessagingException;
import org.sonatype.micromailer.MailCompositionTemplateException;
import org.sonatype.micromailer.MailPart;
import org.sonatype.micromailer.MailRequest;
import org.sonatype.micromailer.MailType;

@Singleton
@Named
public class DefaultMailComposer
implements MailComposer {
    public static final String MESSAGE_FROM = "From";
    public static final String MESSAGE_TO = "To";
    public static final String MESSAGE_BCC = "Bcc";
    public static final String MESSAGE_SENDER = "Sender";
    public static final String X_MESSAGE_ID_HEADER = "X-EMailer-Mail-Request-ID";
    private final Provider<VelocityEngine> velocityEngineProvider;
    protected Map<String, Object> initialVelocityContext;

    @Inject
    public DefaultMailComposer(Provider<VelocityEngine> velocityEngineProvider) {
        this.velocityEngineProvider = velocityEngineProvider;
    }

    public Map<String, Object> getInitialVelocityContext() {
        return this.initialVelocityContext;
    }

    public void setInitialVelocityContext(Map<String, Object> initialVelocityContext) {
        this.initialVelocityContext = initialVelocityContext;
    }

    @Override
    public void composeMail(EmailerConfiguration configuration, MailRequest request, MailType mailType) throws MailCompositionTemplateException, MailCompositionAttachmentException, MailCompositionMessagingException {
        if (request.getExpandedSubject() == null) {
            request.setExpandedSubject(this.expandTemplateFromString(mailType.getSubjectTemplate(), request.getBodyContext()));
        }
        if (request.getExpandedBody() == null) {
            request.setExpandedBody(this.expandTemplateFromString(mailType.getBodyTemplate(), request.getBodyContext()));
        }
        try {
            MimeBodyPart mimeBodyPart;
            Session session = configuration.getSession();
            MimeMessage message = new MimeMessage(session);
            MimeMultipart root = new MimeMultipart("related");
            message.setContent((Multipart)root);
            if (request.getCustomHeaders().size() > 0) {
                for (String key : request.getCustomHeaders().keySet()) {
                    message.addHeader(key, request.getCustomHeaders().get(key));
                }
            }
            if (request.getRequestId() != null) {
                message.addHeader(X_MESSAGE_ID_HEADER, request.getRequestId());
            }
            if (request.getSender() != null) {
                message.setSender((javax.mail.Address)request.getSender().getInternetAddress(request.getEncoding()));
            }
            if (request.getFrom() != null) {
                message.setFrom((javax.mail.Address)request.getFrom().getInternetAddress(request.getEncoding()));
            }
            if (request.getReplyTo() != null) {
                message.setReplyTo((javax.mail.Address[])new InternetAddress[]{request.getReplyTo().getInternetAddress(request.getEncoding())});
            }
            if (request.getSentDate() != null) {
                message.setSentDate(request.getSentDate());
            } else {
                message.setSentDate(new Date());
            }
            this.setRecipientsFromList(request.getEncoding(), message, Message.RecipientType.TO, request.getToAddresses());
            this.setRecipientsFromList(request.getEncoding(), message, Message.RecipientType.BCC, request.getBccAddresses());
            this.setRecipientsFromList(request.getEncoding(), message, Message.RecipientType.CC, request.getCcAddresses());
            message.setSubject(request.getExpandedSubject(), request.getEncoding());
            MimeBodyPart body = new MimeBodyPart();
            root.addBodyPart((BodyPart)body);
            if (mailType.isBodyIsHtml()) {
                body.setContent((Object)request.getExpandedBody(), "text/html;charset=" + request.getEncoding());
            } else {
                body.setText(request.getExpandedBody(), request.getEncoding());
            }
            for (String key : mailType.getInlineResources().keySet()) {
                mimeBodyPart = new MimeBodyPart();
                mimeBodyPart.setDisposition("inline");
                mimeBodyPart.setContentID(key);
                mimeBodyPart.setDataHandler(new DataHandler(mailType.getInlineResources().get(key)));
                root.addBodyPart((BodyPart)mimeBodyPart);
            }
            for (String key : request.getAttachmentMap().keySet()) {
                mimeBodyPart = new MimeBodyPart();
                mimeBodyPart.setDisposition("attachment");
                mimeBodyPart.setFileName(key);
                mimeBodyPart.setDataHandler(new DataHandler(request.getAttachmentMap().get(key)));
                root.addBodyPart((BodyPart)mimeBodyPart);
            }
            for (MailPart part : request.getParts()) {
                mimeBodyPart = new MimeBodyPart();
                mimeBodyPart.setDisposition(part.getDisposition());
                if (part.getFilename() != null) {
                    mimeBodyPart.setFileName(part.getFilename());
                }
                if (part.getContentId() != null) {
                    mimeBodyPart.setContentID(part.getContentId());
                }
                if (part.getContentLocation() != null) {
                    mimeBodyPart.setHeader("Content-Location", part.getContentLocation());
                }
                for (Map.Entry<String, String> entry : part.getHeaders().entrySet()) {
                    if (entry.getValue() == null) {
                        mimeBodyPart.removeHeader(entry.getKey());
                        continue;
                    }
                    mimeBodyPart.setHeader(entry.getKey(), entry.getValue());
                }
                mimeBodyPart.setDataHandler(part.getContent());
                root.addBodyPart((BodyPart)mimeBodyPart);
            }
            if (message.getHeader(MESSAGE_FROM, null) == null) {
                throw new MailCompositionMessagingException("E-Mail 'From' field is mandatory!");
            }
            if (message.getHeader(MESSAGE_TO, null) == null && message.getHeader(MESSAGE_BCC, null) == null) {
                throw new MailCompositionMessagingException("One of the 'To' or 'Bcc' header is mandatory!");
            }
            message.saveChanges();
            request.setMimeMessage(message);
        }
        catch (UnsupportedEncodingException ex) {
            throw new MailCompositionMessagingException("Unsupported encoding occurred!", ex);
        }
        catch (MessagingException ex) {
            throw new MailCompositionMessagingException("MessagingException occurred!", ex);
        }
    }

    protected void setRecipientsFromList(String encoding, MimeMessage message, Message.RecipientType type, List<Address> addresses) throws MessagingException, UnsupportedEncodingException {
        if (addresses == null || addresses.size() == 0) {
            return;
        }
        InternetAddress[] adrs = new InternetAddress[addresses.size()];
        for (int i = 0; i < addresses.size(); ++i) {
            adrs[i] = addresses.get(i).getInternetAddress(encoding);
        }
        message.setRecipients(type, (javax.mail.Address[])adrs);
    }

    protected String expandTemplateFromString(String template, Map<String, Object> model) throws MailCompositionTemplateException {
        try {
            StringWriter sw = new StringWriter();
            VelocityContext context = new VelocityContext(this.getInitialVelocityContext(), (Context)new VelocityContext(model));
            ((VelocityEngine)this.velocityEngineProvider.get()).evaluate((Context)context, (Writer)sw, "SUBJECT", template);
            return sw.toString();
        }
        catch (Exception ex) {
            throw new MailCompositionTemplateException("Velocity throw exception during template merge.", ex);
        }
    }

    protected String expandTemplateFromResource(String templateResourceName, Map<String, Object> model) throws MailCompositionTemplateException {
        try {
            StringWriter sw = new StringWriter();
            Template template = ((VelocityEngine)this.velocityEngineProvider.get()).getTemplate(templateResourceName, "UTF-8");
            VelocityContext context = new VelocityContext(this.getInitialVelocityContext(), (Context)new VelocityContext(model));
            template.merge((Context)context, (Writer)sw);
            return sw.toString();
        }
        catch (Exception ex) {
            throw new MailCompositionTemplateException("Velocity throw exception during template merge.", ex);
        }
    }
}

