/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.micromailer.imp;

import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.micromailer.EMailer;
import org.sonatype.micromailer.EmailerConfiguration;
import org.sonatype.micromailer.MailComposer;
import org.sonatype.micromailer.MailCompositionException;
import org.sonatype.micromailer.MailCompositionTemplateException;
import org.sonatype.micromailer.MailRequest;
import org.sonatype.micromailer.MailRequestSource;
import org.sonatype.micromailer.MailRequestStatus;
import org.sonatype.micromailer.MailSender;
import org.sonatype.micromailer.MailStorage;
import org.sonatype.micromailer.MailType;
import org.sonatype.micromailer.MailTypeSource;

@Singleton
@Named
public class DefaultEMailer
implements EMailer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    private MailTypeSource mailTypeSource;
    @Inject
    private MailComposer mailComposer;
    @Inject
    private MailStorage mailStorage;
    @Inject
    private MailSender mailSender;
    private EmailerConfiguration emailerConfiguration = new EmailerConfiguration();
    private final ExecutorService executorService = new ThreadPoolExecutor(0, 20, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());

    @Override
    public void configure(EmailerConfiguration config) {
        this.emailerConfiguration = config;
    }

    @Override
    public void shutdown() {
        this.executorService.shutdownNow();
    }

    @Override
    public MailTypeSource getMailTypeSource() {
        return this.mailTypeSource;
    }

    @Override
    public MailComposer getMailComposer() {
        return this.mailComposer;
    }

    @Override
    public MailStorage getMailStorage() {
        return this.mailStorage;
    }

    @Override
    public MailSender getMailSender() {
        return this.mailSender;
    }

    @Override
    public MailRequestStatus sendMail(MailRequest request) {
        return this.handleMailRequest(request);
    }

    @Override
    public void sendMailBatch(MailRequestSource mailRequestSource) {
        if (mailRequestSource.hasWaitingRequests()) {
            this.logger.info("* Got batch request, processing it...");
            Iterator<MailRequest> i = mailRequestSource.getRequestIterator();
            while (i.hasNext()) {
                MailRequest request = i.next();
                MailRequestStatus status = this.handleMailRequest(request);
                mailRequestSource.setMailRequestStatus(request, status);
            }
            this.logger.info("* Finished batch request processing.");
        }
    }

    protected MailRequestStatus handleMailRequest(MailRequest request) {
        this.logger.info("  Handling mail request {}", (Object)request.getRequestId());
        MailRequestStatus status = new MailRequestStatus(request);
        this.executorService.execute(this.createMailer(request, status));
        return status;
    }

    private RunnableMailer createMailer(MailRequest request, MailRequestStatus status) {
        return new RunnableMailer(this.logger, request, this.mailTypeSource, this.mailComposer, this.emailerConfiguration, this.mailStorage, this.mailSender, status);
    }

    @Override
    public MailRequestStatus sendSyncedMail(MailRequest request) {
        MailRequestStatus status = new MailRequestStatus(request);
        this.createMailer(request, status).run();
        return status;
    }

    private static final class RunnableMailer
    implements Runnable {
        private Logger logger;
        private MailRequest request;
        private MailTypeSource mailTypeSource;
        private MailComposer mailComposer;
        private EmailerConfiguration emailerConfiguration;
        private MailStorage mailStorage;
        private MailSender mailSender;
        private MailRequestStatus status;

        protected RunnableMailer(Logger logger, MailRequest request, MailTypeSource mailTypeSource, MailComposer mailComposer, EmailerConfiguration emailerConfiguration, MailStorage mailStorage, MailSender mailSender, MailRequestStatus status) {
            this.logger = logger;
            this.request = request;
            this.mailTypeSource = mailTypeSource;
            this.mailComposer = mailComposer;
            this.emailerConfiguration = emailerConfiguration;
            this.mailStorage = mailStorage;
            this.mailSender = mailSender;
            this.status = status;
        }

        @Override
        public void run() {
            try {
                MailType mailType;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("  PREPARING {}", (Object)this.request.getRequestId());
                }
                if ((mailType = this.mailTypeSource.getMailType(this.request.getMailTypeId())) != null) {
                    this.mailComposer.composeMail(this.emailerConfiguration, this.request, mailType);
                    this.status.setPrepared(true);
                    if (this.request.isStoreable() || mailType.isStoreable()) {
                        this.mailStorage.saveMailRequest(this.request);
                        this.status.setStored(true);
                    }
                    this.mailSender.sendMail(this.emailerConfiguration, this.request, mailType);
                    this.status.setSent(true);
                } else {
                    this.status.setErrorCause(new MailCompositionTemplateException("Unknown mailType with ID='" + this.request.getMailTypeId() + "'"));
                }
            }
            catch (MailCompositionException ex) {
                this.handleException(ex);
            }
            catch (IOException ex) {
                this.handleException(ex);
            }
        }

        private void handleException(Exception ex) {
            if (this.logger.isDebugEnabled()) {
                this.logger.warn("Problem delivering mail requestId[{}]", (Object)this.request.getRequestId(), (Object)ex);
            } else {
                this.logger.warn("Problem delivering mail requestId[{}]: {}/{}", new Object[]{this.request.getRequestId(), ex.getClass().getName(), ex.getMessage()});
            }
            this.status.setErrorCause(ex);
        }
    }
}

