/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.micromailer;

import java.security.Security;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.Session;
import org.sonatype.micromailer.MailCompositionMessagingException;
import org.sonatype.micromailer.imp.DefaultAuthenticator;
import org.sonatype.micromailer.imp.Strings;

public class EmailerConfiguration {
    private boolean storeMails = false;
    private boolean sendMails = true;
    private String mailHost = null;
    private int mailPort = 25;
    private String bounceAddress = null;
    private String username = null;
    private String password = null;
    private boolean isTls = false;
    private boolean isSsl = false;
    private boolean debug = false;
    private static final String MAIL_HOST = "mail.smtp.host";
    private static final String MAIL_PORT = "mail.smtp.port";
    private static final String MAIL_SMTP_FROM = "mail.smtp.from";
    private static final String MAIL_SMTP_AUTH = "mail.smtp.auth";
    private static final String MAIL_TRANSPORT_PROTOCOL = "mail.transport.protocol";
    private static final String MAIL_TRANSPORT_TLS = "mail.smtp.starttls.enable";
    private static final String MAIL_SMTP_SOCKET_FACTORY_FALLBACK = "mail.smtp.socketFactory.fallback";
    private static final String MAIL_SMTP_SOCKET_FACTORY_CLASS = "mail.smtp.socketFactory.class";
    private static final String MAIL_SMTP_SOCKET_FACTORY_PORT = "mail.smtp.socketFactory.port";
    private static final String MAIL_DEBUG = "mail.debug";
    private transient Session session;

    public boolean isStoreMails() {
        return this.storeMails;
    }

    public void setStoreMails(boolean storeMails) {
        this.storeMails = storeMails;
    }

    public boolean isSendMails() {
        return this.sendMails;
    }

    public void setSendMails(boolean sendMails) {
        this.sendMails = sendMails;
    }

    public String getMailHost() {
        return this.mailHost;
    }

    public void setMailHost(String mailHost) {
        this.mailHost = mailHost;
    }

    public int getMailPort() {
        return this.mailPort;
    }

    public void setMailPort(int mailPort) {
        this.mailPort = mailPort;
    }

    public String getBounceAddress() {
        return this.bounceAddress;
    }

    public void setBounceAddress(String bounceAddress) {
        this.bounceAddress = bounceAddress;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isTls() {
        return this.isTls;
    }

    public void setTls(boolean isTls) {
        this.isTls = isTls;
    }

    public boolean isSsl() {
        return this.isSsl;
    }

    public void setSsl(boolean isSsl) {
        if (isSsl && this.getMailPort() == 25) {
            this.setMailPort(465);
        }
        this.isSsl = isSsl;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public Authenticator getAuthenticator() {
        if (Strings.isNotEmpty(this.getUsername())) {
            return new DefaultAuthenticator(this.getUsername(), this.getPassword());
        }
        return null;
    }

    public Session getSession() throws MailCompositionMessagingException {
        if (this.session == null) {
            Properties properties = new Properties(System.getProperties());
            properties.setProperty(MAIL_TRANSPORT_PROTOCOL, "smtp");
            if (Strings.isEmpty(this.getMailHost())) {
                this.setMailHost(properties.getProperty(MAIL_HOST));
            }
            if (Strings.isEmpty(this.getMailHost())) {
                throw new MailCompositionMessagingException("Cannot find valid hostname for mail session");
            }
            properties.setProperty(MAIL_PORT, String.valueOf(this.getMailPort()));
            properties.setProperty(MAIL_HOST, this.getMailHost());
            properties.setProperty(MAIL_DEBUG, String.valueOf(this.isDebug()));
            Authenticator authenticator = this.getAuthenticator();
            if (authenticator != null) {
                properties.setProperty(MAIL_SMTP_AUTH, "true");
                properties.setProperty(MAIL_TRANSPORT_TLS, this.isTls() ? "true" : "false");
                if (this.isTls() && this.isDebug()) {
                    properties.setProperty(MAIL_SMTP_SOCKET_FACTORY_FALLBACK, "false");
                    Security.setProperty("ssl.SocketFactory.provider", "org.sonatype.micromailer.imp.DebugTLSSocketFactory");
                }
            }
            if (this.isSsl()) {
                properties.setProperty(MAIL_SMTP_SOCKET_FACTORY_PORT, String.valueOf(this.getMailPort()));
                properties.setProperty(MAIL_SMTP_SOCKET_FACTORY_FALLBACK, "false");
                if (this.isDebug()) {
                    Security.setProperty("ssl.SocketFactory.provider", "org.sonatype.micromailer.imp.DebugSSLSocketFactory");
                } else {
                    properties.setProperty(MAIL_SMTP_SOCKET_FACTORY_CLASS, "javax.net.ssl.SSLSocketFactory");
                }
            }
            if (this.getBounceAddress() != null) {
                properties.setProperty(MAIL_SMTP_FROM, this.getBounceAddress());
            }
            this.session = this.createSession(properties, authenticator);
        }
        return this.session;
    }

    protected Session createSession(Properties properties, Authenticator authenticator) {
        return Session.getInstance((Properties)properties, (Authenticator)authenticator);
    }
}

