/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.micromailer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;

public class ClasspathResource
implements DataSource {
    private final String path;
    private final String name;
    private final String contentType;
    private final ClassLoader classLoader;

    public ClasspathResource(String path, String name, String contentType) {
        this(path, name, contentType, null);
    }

    public ClasspathResource(String path, String name, String contentType, ClassLoader cl) {
        this.path = path;
        this.name = name;
        this.contentType = contentType;
        this.classLoader = cl;
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        return this.name;
    }

    public String getContentType() {
        return this.contentType;
    }

    public InputStream getInputStream() throws IOException {
        if (this.classLoader != null) {
            return this.classLoader.getResourceAsStream(this.getPath());
        }
        return this.getClass().getResourceAsStream(this.getPath());
    }

    public OutputStream getOutputStream() throws IOException {
        throw new UnsupportedOperationException("Classpath resource is not writable!");
    }
}

