/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.micromailer;

import java.io.UnsupportedEncodingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.sonatype.micromailer.imp.Strings;

public class Address {
    private final String mailAddress;
    private final String personal;

    public Address(String mailAddress) throws IllegalArgumentException {
        this(mailAddress, null);
    }

    public Address(String mailAddress, String personal) throws IllegalArgumentException {
        this.mailAddress = mailAddress;
        this.personal = personal;
        Address.validateAddress(this);
    }

    public String getMailAddress() {
        return this.mailAddress;
    }

    public String getPersonal() {
        return this.personal;
    }

    public InternetAddress getInternetAddress(String encoding) throws AddressException, UnsupportedEncodingException {
        InternetAddress adr = new InternetAddress(this.getMailAddress(), this.getPersonal(), encoding);
        adr.validate();
        return adr;
    }

    public String toString() {
        if (Strings.isEmpty(this.getPersonal())) {
            return "<" + this.getMailAddress() + ">";
        }
        return "\"" + this.getPersonal() + "\" <" + this.getMailAddress() + ">";
    }

    public static void validateAddress(String address) throws IllegalArgumentException {
        if (Strings.isEmpty(address)) {
            throw new IllegalArgumentException("E-mail address cannot be empty!");
        }
        Address.validateAddress(new Address(address));
    }

    public static void validateAddress(Address address) throws IllegalArgumentException {
        if (address == null) {
            throw new IllegalArgumentException("E-mail address is null!");
        }
        try {
            address.getInternetAddress("UTF-8");
        }
        catch (AddressException e) {
            throw new IllegalArgumentException("Invalida e-mail address: " + address.toString(), e);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("EMailer needs a JVM that supports UTF-8 encoding!");
        }
    }
}

