/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.servlet;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.inject.AbstractModule;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.servlet.FiltersModuleBuilder;
import com.google.inject.servlet.GuiceFilter;
import com.google.inject.servlet.InternalServletModule;
import com.google.inject.servlet.ServletsModuleBuilder;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;

public class ServletModule
extends AbstractModule {
    private FiltersModuleBuilder filtersModuleBuilder;
    private ServletsModuleBuilder servletsModuleBuilder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void configure() {
        Preconditions.checkState((this.filtersModuleBuilder == null ? 1 : 0) != 0, (Object)"Re-entry is not allowed.");
        Preconditions.checkState((this.servletsModuleBuilder == null ? 1 : 0) != 0, (Object)"Re-entry is not allowed.");
        this.filtersModuleBuilder = new FiltersModuleBuilder(this.binder());
        this.servletsModuleBuilder = new ServletsModuleBuilder(this.binder());
        try {
            this.install((Module)new InternalServletModule());
            this.configureServlets();
        }
        finally {
            this.filtersModuleBuilder = null;
            this.servletsModuleBuilder = null;
        }
    }

    protected void configureServlets() {
    }

    private FiltersModuleBuilder getFiltersModuleBuilder() {
        Preconditions.checkState((this.filtersModuleBuilder != null ? 1 : 0) != 0, (Object)"This method can only be used inside configureServlets()");
        return this.filtersModuleBuilder;
    }

    private ServletsModuleBuilder getServletModuleBuilder() {
        Preconditions.checkState((this.servletsModuleBuilder != null ? 1 : 0) != 0, (Object)"This method can only be used inside configureServlets()");
        return this.servletsModuleBuilder;
    }

    protected final FilterKeyBindingBuilder filter(String urlPattern, String ... morePatterns) {
        return this.getFiltersModuleBuilder().filter((List<String>)ImmutableList.builder().add((Object)urlPattern).add((Object[])morePatterns).build());
    }

    protected final FilterKeyBindingBuilder filterRegex(String regex, String ... regexes) {
        return this.getFiltersModuleBuilder().filterRegex((List<String>)ImmutableList.builder().add((Object)regex).add((Object[])regexes).build());
    }

    protected final ServletKeyBindingBuilder serve(String urlPattern, String ... morePatterns) {
        return this.getServletModuleBuilder().serve((List<String>)ImmutableList.builder().add((Object)urlPattern).add((Object[])morePatterns).build());
    }

    protected final ServletKeyBindingBuilder serveRegex(String regex, String ... regexes) {
        return this.getServletModuleBuilder().serveRegex((List<String>)ImmutableList.builder().add((Object)regex).add((Object[])regexes).build());
    }

    protected final ServletContext getServletContext() {
        return GuiceFilter.getServletContext();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ServletKeyBindingBuilder {
        public void with(Class<? extends HttpServlet> var1);

        public void with(Key<? extends HttpServlet> var1);

        public void with(HttpServlet var1);

        public void with(Class<? extends HttpServlet> var1, Map<String, String> var2);

        public void with(Key<? extends HttpServlet> var1, Map<String, String> var2);

        public void with(HttpServlet var1, Map<String, String> var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface FilterKeyBindingBuilder {
        public void through(Class<? extends Filter> var1);

        public void through(Key<? extends Filter> var1);

        public void through(Filter var1);

        public void through(Class<? extends Filter> var1, Map<String, String> var2);

        public void through(Key<? extends Filter> var1, Map<String, String> var2);

        public void through(Filter var1, Map<String, String> var2);
    }
}

