/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.servlet;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Binding;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.servlet.FilterChainInvocation;
import com.google.inject.servlet.FilterDefinition;
import com.google.inject.servlet.FilterPipeline;
import com.google.inject.servlet.ManagedServletPipeline;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
class ManagedFilterPipeline
implements FilterPipeline {
    private final FilterDefinition[] filterDefinitions;
    private final ManagedServletPipeline servletPipeline;
    private final Provider<ServletContext> servletContext;
    private final Injector injector;
    private volatile boolean initialized = false;
    private static final TypeLiteral<FilterDefinition> FILTER_DEFS = TypeLiteral.get(FilterDefinition.class);

    @Inject
    public ManagedFilterPipeline(Injector injector, ManagedServletPipeline servletPipeline, Provider<ServletContext> servletContext) {
        this.injector = injector;
        this.servletPipeline = servletPipeline;
        this.servletContext = servletContext;
        this.filterDefinitions = this.collectFilterDefinitions(injector);
    }

    private FilterDefinition[] collectFilterDefinitions(Injector injector) {
        ArrayList filterDefinitions = Lists.newArrayList();
        for (Binding entry : injector.findBindingsByType(FILTER_DEFS)) {
            filterDefinitions.add(entry.getProvider().get());
        }
        return filterDefinitions.toArray(new FilterDefinition[filterDefinitions.size()]);
    }

    @Override
    public synchronized void initPipeline(ServletContext servletContext) throws ServletException {
        if (this.initialized) {
            return;
        }
        Set initializedSoFar = Sets.newSetFromMap((Map)Maps.newIdentityHashMap());
        for (FilterDefinition filterDefinition : this.filterDefinitions) {
            filterDefinition.init(servletContext, this.injector, initializedSoFar);
        }
        this.servletPipeline.init(servletContext, this.injector);
        this.initialized = true;
    }

    @Override
    public void dispatch(ServletRequest request, ServletResponse response, FilterChain proceedingFilterChain) throws IOException, ServletException {
        if (!this.initialized) {
            this.initPipeline((ServletContext)this.servletContext.get());
        }
        new FilterChainInvocation(this.filterDefinitions, this.servletPipeline, proceedingFilterChain).doFilter(this.withDispatcher(request, this.servletPipeline), response);
    }

    private ServletRequest withDispatcher(ServletRequest servletRequest, final ManagedServletPipeline servletPipeline) {
        if (!servletPipeline.hasServletsMapped()) {
            return servletRequest;
        }
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        return new HttpServletRequestWrapper(request){

            public RequestDispatcher getRequestDispatcher(String path) {
                RequestDispatcher dispatcher = servletPipeline.getRequestDispatcher(path);
                return null != dispatcher ? dispatcher : super.getRequestDispatcher(path);
            }
        };
    }

    @Override
    public void destroyPipeline() {
        this.servletPipeline.destroy();
        Set destroyedSoFar = Sets.newSetFromMap((Map)Maps.newIdentityHashMap());
        for (FilterDefinition filterDefinition : this.filterDefinitions) {
            filterDefinition.destroy(destroyedSoFar);
        }
    }
}

