/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.configuration.model.v2_5_0.io.xpp3;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;
import org.sonatype.nexus.configuration.model.v2_5_0.CErrorReporting;
import org.sonatype.nexus.configuration.model.v2_5_0.CHttpProxySettings;
import org.sonatype.nexus.configuration.model.v2_5_0.CLocalStorage;
import org.sonatype.nexus.configuration.model.v2_5_0.CMirror;
import org.sonatype.nexus.configuration.model.v2_5_0.CNotification;
import org.sonatype.nexus.configuration.model.v2_5_0.CNotificationTarget;
import org.sonatype.nexus.configuration.model.v2_5_0.CPathMappingItem;
import org.sonatype.nexus.configuration.model.v2_5_0.CPlugin;
import org.sonatype.nexus.configuration.model.v2_5_0.CProps;
import org.sonatype.nexus.configuration.model.v2_5_0.CRemoteAuthentication;
import org.sonatype.nexus.configuration.model.v2_5_0.CRemoteConnectionSettings;
import org.sonatype.nexus.configuration.model.v2_5_0.CRemoteHttpProxySettings;
import org.sonatype.nexus.configuration.model.v2_5_0.CRemoteNexusInstance;
import org.sonatype.nexus.configuration.model.v2_5_0.CRemoteProxySettings;
import org.sonatype.nexus.configuration.model.v2_5_0.CRemoteStorage;
import org.sonatype.nexus.configuration.model.v2_5_0.CRepository;
import org.sonatype.nexus.configuration.model.v2_5_0.CRepositoryGrouping;
import org.sonatype.nexus.configuration.model.v2_5_0.CRepositoryTarget;
import org.sonatype.nexus.configuration.model.v2_5_0.CRestApiSettings;
import org.sonatype.nexus.configuration.model.v2_5_0.CRouting;
import org.sonatype.nexus.configuration.model.v2_5_0.CScheduleConfig;
import org.sonatype.nexus.configuration.model.v2_5_0.CScheduledTask;
import org.sonatype.nexus.configuration.model.v2_5_0.CSmtpConfiguration;
import org.sonatype.nexus.configuration.model.v2_5_0.Configuration;

public class NexusConfigurationXpp3Writer {
    private static final String NAMESPACE = null;

    public void write(Writer writer, Configuration configuration) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        serializer.setOutput(writer);
        serializer.startDocument(configuration.getModelEncoding(), null);
        this.writeConfiguration(configuration, "nexusConfiguration", (XmlSerializer)serializer);
        serializer.endDocument();
    }

    public void write(OutputStream stream, Configuration configuration) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        serializer.setOutput(stream, configuration.getModelEncoding());
        serializer.startDocument(configuration.getModelEncoding(), null);
        this.writeConfiguration(configuration, "nexusConfiguration", (XmlSerializer)serializer);
        serializer.endDocument();
    }

    private void writeCErrorReporting(CErrorReporting cErrorReporting, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (cErrorReporting.isEnabled()) {
            serializer.startTag(NAMESPACE, "enabled").text(String.valueOf(cErrorReporting.isEnabled())).endTag(NAMESPACE, "enabled");
        }
        if (cErrorReporting.getJiraUrl() != null) {
            serializer.startTag(NAMESPACE, "jiraUrl").text(cErrorReporting.getJiraUrl()).endTag(NAMESPACE, "jiraUrl");
        }
        if (cErrorReporting.getJiraProject() != null) {
            serializer.startTag(NAMESPACE, "jiraProject").text(cErrorReporting.getJiraProject()).endTag(NAMESPACE, "jiraProject");
        }
        if (cErrorReporting.getJiraUsername() != null) {
            serializer.startTag(NAMESPACE, "jiraUsername").text(cErrorReporting.getJiraUsername()).endTag(NAMESPACE, "jiraUsername");
        }
        if (cErrorReporting.getJiraPassword() != null) {
            serializer.startTag(NAMESPACE, "jiraPassword").text(cErrorReporting.getJiraPassword()).endTag(NAMESPACE, "jiraPassword");
        }
        if (cErrorReporting.isUseGlobalProxy()) {
            serializer.startTag(NAMESPACE, "useGlobalProxy").text(String.valueOf(cErrorReporting.isUseGlobalProxy())).endTag(NAMESPACE, "useGlobalProxy");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeCHttpProxySettings(CHttpProxySettings cHttpProxySettings, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (cHttpProxySettings.isEnabled()) {
            serializer.startTag(NAMESPACE, "enabled").text(String.valueOf(cHttpProxySettings.isEnabled())).endTag(NAMESPACE, "enabled");
        }
        if (cHttpProxySettings.getPort() != 0) {
            serializer.startTag(NAMESPACE, "port").text(String.valueOf(cHttpProxySettings.getPort())).endTag(NAMESPACE, "port");
        }
        if (cHttpProxySettings.getProxyPolicy() != null) {
            serializer.startTag(NAMESPACE, "proxyPolicy").text(cHttpProxySettings.getProxyPolicy()).endTag(NAMESPACE, "proxyPolicy");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeCLocalStorage(CLocalStorage cLocalStorage, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (cLocalStorage.getProvider() != null) {
            serializer.startTag(NAMESPACE, "provider").text(cLocalStorage.getProvider()).endTag(NAMESPACE, "provider");
        }
        if (cLocalStorage.getUrl() != null) {
            serializer.startTag(NAMESPACE, "url").text(cLocalStorage.getUrl()).endTag(NAMESPACE, "url");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeCMirror(CMirror cMirror, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (cMirror.getId() != null) {
            serializer.startTag(NAMESPACE, "id").text(cMirror.getId()).endTag(NAMESPACE, "id");
        }
        if (cMirror.getUrl() != null) {
            serializer.startTag(NAMESPACE, "url").text(cMirror.getUrl()).endTag(NAMESPACE, "url");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeCNotification(CNotification cNotification, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (cNotification.isEnabled()) {
            serializer.startTag(NAMESPACE, "enabled").text(String.valueOf(cNotification.isEnabled())).endTag(NAMESPACE, "enabled");
        }
        if (cNotification.getNotificationTargets() != null && cNotification.getNotificationTargets().size() > 0) {
            serializer.startTag(NAMESPACE, "notificationTargets");
            for (CNotificationTarget o : cNotification.getNotificationTargets()) {
                this.writeCNotificationTarget(o, "notificationTarget", serializer);
            }
            serializer.endTag(NAMESPACE, "notificationTargets");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeCNotificationTarget(CNotificationTarget cNotificationTarget, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (cNotificationTarget.getTargetId() != null) {
            serializer.startTag(NAMESPACE, "targetId").text(cNotificationTarget.getTargetId()).endTag(NAMESPACE, "targetId");
        }
        if (cNotificationTarget.getTargetRoles() != null && cNotificationTarget.getTargetRoles().size() > 0) {
            serializer.startTag(NAMESPACE, "targetRoles");
            for (String targetRole : cNotificationTarget.getTargetRoles()) {
                serializer.startTag(NAMESPACE, "targetRole").text(targetRole).endTag(NAMESPACE, "targetRole");
            }
            serializer.endTag(NAMESPACE, "targetRoles");
        }
        if (cNotificationTarget.getTargetUsers() != null && cNotificationTarget.getTargetUsers().size() > 0) {
            serializer.startTag(NAMESPACE, "targetUsers");
            for (String targetUser : cNotificationTarget.getTargetUsers()) {
                serializer.startTag(NAMESPACE, "targetUser").text(targetUser).endTag(NAMESPACE, "targetUser");
            }
            serializer.endTag(NAMESPACE, "targetUsers");
        }
        if (cNotificationTarget.getTargetExternals() != null && cNotificationTarget.getTargetExternals().size() > 0) {
            serializer.startTag(NAMESPACE, "targetExternals");
            for (String targetExternal : cNotificationTarget.getTargetExternals()) {
                serializer.startTag(NAMESPACE, "targetExternal").text(targetExternal).endTag(NAMESPACE, "targetExternal");
            }
            serializer.endTag(NAMESPACE, "targetExternals");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeCPathMappingItem(CPathMappingItem cPathMappingItem, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (cPathMappingItem.getId() != null) {
            serializer.startTag(NAMESPACE, "id").text(cPathMappingItem.getId()).endTag(NAMESPACE, "id");
        }
        if (cPathMappingItem.getGroupId() != null) {
            serializer.startTag(NAMESPACE, "groupId").text(cPathMappingItem.getGroupId()).endTag(NAMESPACE, "groupId");
        }
        if (cPathMappingItem.getRouteType() != null) {
            serializer.startTag(NAMESPACE, "routeType").text(cPathMappingItem.getRouteType()).endTag(NAMESPACE, "routeType");
        }
        if (cPathMappingItem.getRoutePatterns() != null && cPathMappingItem.getRoutePatterns().size() > 0) {
            serializer.startTag(NAMESPACE, "routePatterns");
            for (String routePattern : cPathMappingItem.getRoutePatterns()) {
                serializer.startTag(NAMESPACE, "routePattern").text(routePattern).endTag(NAMESPACE, "routePattern");
            }
            serializer.endTag(NAMESPACE, "routePatterns");
        }
        if (cPathMappingItem.getRepositories() != null && cPathMappingItem.getRepositories().size() > 0) {
            serializer.startTag(NAMESPACE, "repositories");
            for (String repository : cPathMappingItem.getRepositories()) {
                serializer.startTag(NAMESPACE, "repository").text(repository).endTag(NAMESPACE, "repository");
            }
            serializer.endTag(NAMESPACE, "repositories");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeCPlugin(CPlugin cPlugin, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (cPlugin.getType() != null) {
            serializer.startTag(NAMESPACE, "type").text(cPlugin.getType()).endTag(NAMESPACE, "type");
        }
        if (cPlugin.getId() != null) {
            serializer.startTag(NAMESPACE, "id").text(cPlugin.getId()).endTag(NAMESPACE, "id");
        }
        if (cPlugin.getName() != null) {
            serializer.startTag(NAMESPACE, "name").text(cPlugin.getName()).endTag(NAMESPACE, "name");
        }
        if (cPlugin.getStatus() != null) {
            serializer.startTag(NAMESPACE, "status").text(cPlugin.getStatus()).endTag(NAMESPACE, "status");
        }
        if (cPlugin.getExternalConfiguration() != null) {
            ((Xpp3Dom)cPlugin.getExternalConfiguration()).writeToSerializer(NAMESPACE, serializer);
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeCProps(CProps cProps, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (cProps.getKey() != null) {
            serializer.startTag(NAMESPACE, "key").text(cProps.getKey()).endTag(NAMESPACE, "key");
        }
        if (cProps.getValue() != null) {
            serializer.startTag(NAMESPACE, "value").text(cProps.getValue()).endTag(NAMESPACE, "value");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeCRemoteAuthentication(CRemoteAuthentication cRemoteAuthentication, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (cRemoteAuthentication.getUsername() != null) {
            serializer.startTag(NAMESPACE, "username").text(cRemoteAuthentication.getUsername()).endTag(NAMESPACE, "username");
        }
        if (cRemoteAuthentication.getPassword() != null) {
            serializer.startTag(NAMESPACE, "password").text(cRemoteAuthentication.getPassword()).endTag(NAMESPACE, "password");
        }
        if (cRemoteAuthentication.getNtlmHost() != null) {
            serializer.startTag(NAMESPACE, "ntlmHost").text(cRemoteAuthentication.getNtlmHost()).endTag(NAMESPACE, "ntlmHost");
        }
        if (cRemoteAuthentication.getNtlmDomain() != null) {
            serializer.startTag(NAMESPACE, "ntlmDomain").text(cRemoteAuthentication.getNtlmDomain()).endTag(NAMESPACE, "ntlmDomain");
        }
        if (cRemoteAuthentication.getTrustStore() != null) {
            serializer.startTag(NAMESPACE, "trustStore").text(cRemoteAuthentication.getTrustStore()).endTag(NAMESPACE, "trustStore");
        }
        if (cRemoteAuthentication.getTrustStorePassword() != null) {
            serializer.startTag(NAMESPACE, "trustStorePassword").text(cRemoteAuthentication.getTrustStorePassword()).endTag(NAMESPACE, "trustStorePassword");
        }
        if (cRemoteAuthentication.getKeyStore() != null) {
            serializer.startTag(NAMESPACE, "keyStore").text(cRemoteAuthentication.getKeyStore()).endTag(NAMESPACE, "keyStore");
        }
        if (cRemoteAuthentication.getKeyStorePassword() != null) {
            serializer.startTag(NAMESPACE, "keyStorePassword").text(cRemoteAuthentication.getKeyStorePassword()).endTag(NAMESPACE, "keyStorePassword");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeCRemoteConnectionSettings(CRemoteConnectionSettings cRemoteConnectionSettings, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (cRemoteConnectionSettings.getConnectionTimeout() != 0) {
            serializer.startTag(NAMESPACE, "connectionTimeout").text(String.valueOf(cRemoteConnectionSettings.getConnectionTimeout())).endTag(NAMESPACE, "connectionTimeout");
        }
        if (cRemoteConnectionSettings.getRetrievalRetryCount() != 0) {
            serializer.startTag(NAMESPACE, "retrievalRetryCount").text(String.valueOf(cRemoteConnectionSettings.getRetrievalRetryCount())).endTag(NAMESPACE, "retrievalRetryCount");
        }
        if (cRemoteConnectionSettings.getQueryString() != null) {
            serializer.startTag(NAMESPACE, "queryString").text(cRemoteConnectionSettings.getQueryString()).endTag(NAMESPACE, "queryString");
        }
        if (cRemoteConnectionSettings.getUserAgentCustomizationString() != null) {
            serializer.startTag(NAMESPACE, "userAgentCustomizationString").text(cRemoteConnectionSettings.getUserAgentCustomizationString()).endTag(NAMESPACE, "userAgentCustomizationString");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeCRemoteHttpProxySettings(CRemoteHttpProxySettings cRemoteHttpProxySettings, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (cRemoteHttpProxySettings.getProxyHostname() != null) {
            serializer.startTag(NAMESPACE, "proxyHostname").text(cRemoteHttpProxySettings.getProxyHostname()).endTag(NAMESPACE, "proxyHostname");
        }
        if (cRemoteHttpProxySettings.getProxyPort() != 0) {
            serializer.startTag(NAMESPACE, "proxyPort").text(String.valueOf(cRemoteHttpProxySettings.getProxyPort())).endTag(NAMESPACE, "proxyPort");
        }
        if (cRemoteHttpProxySettings.getAuthentication() != null) {
            this.writeCRemoteAuthentication(cRemoteHttpProxySettings.getAuthentication(), "authentication", serializer);
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeCRemoteNexusInstance(CRemoteNexusInstance cRemoteNexusInstance, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (cRemoteNexusInstance.getAlias() != null) {
            serializer.startTag(NAMESPACE, "alias").text(cRemoteNexusInstance.getAlias()).endTag(NAMESPACE, "alias");
        }
        if (cRemoteNexusInstance.getInstanceUrl() != null) {
            serializer.startTag(NAMESPACE, "instanceUrl").text(cRemoteNexusInstance.getInstanceUrl()).endTag(NAMESPACE, "instanceUrl");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeCRemoteProxySettings(CRemoteProxySettings cRemoteProxySettings, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (cRemoteProxySettings.getHttpProxySettings() != null) {
            this.writeCRemoteHttpProxySettings(cRemoteProxySettings.getHttpProxySettings(), "httpProxySettings", serializer);
        }
        if (cRemoteProxySettings.getHttpsProxySettings() != null) {
            this.writeCRemoteHttpProxySettings(cRemoteProxySettings.getHttpsProxySettings(), "httpsProxySettings", serializer);
        }
        if (cRemoteProxySettings.getNonProxyHosts() != null && cRemoteProxySettings.getNonProxyHosts().size() > 0) {
            serializer.startTag(NAMESPACE, "nonProxyHosts");
            for (String nonProxyHost : cRemoteProxySettings.getNonProxyHosts()) {
                serializer.startTag(NAMESPACE, "nonProxyHost").text(nonProxyHost).endTag(NAMESPACE, "nonProxyHost");
            }
            serializer.endTag(NAMESPACE, "nonProxyHosts");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeCRemoteStorage(CRemoteStorage cRemoteStorage, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (cRemoteStorage.getProvider() != null) {
            serializer.startTag(NAMESPACE, "provider").text(cRemoteStorage.getProvider()).endTag(NAMESPACE, "provider");
        }
        if (cRemoteStorage.getUrl() != null) {
            serializer.startTag(NAMESPACE, "url").text(cRemoteStorage.getUrl()).endTag(NAMESPACE, "url");
        }
        if (cRemoteStorage.getAuthentication() != null) {
            this.writeCRemoteAuthentication(cRemoteStorage.getAuthentication(), "authentication", serializer);
        }
        if (cRemoteStorage.getConnectionSettings() != null) {
            this.writeCRemoteConnectionSettings(cRemoteStorage.getConnectionSettings(), "connectionSettings", serializer);
        }
        if (cRemoteStorage.getMirrors() != null && cRemoteStorage.getMirrors().size() > 0) {
            serializer.startTag(NAMESPACE, "mirrors");
            for (CMirror o : cRemoteStorage.getMirrors()) {
                this.writeCMirror(o, "mirror", serializer);
            }
            serializer.endTag(NAMESPACE, "mirrors");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeCRepository(CRepository cRepository, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (cRepository.getId() != null) {
            serializer.startTag(NAMESPACE, "id").text(cRepository.getId()).endTag(NAMESPACE, "id");
        }
        if (cRepository.getName() != null) {
            serializer.startTag(NAMESPACE, "name").text(cRepository.getName()).endTag(NAMESPACE, "name");
        }
        if (cRepository.getProviderRole() != null) {
            serializer.startTag(NAMESPACE, "providerRole").text(cRepository.getProviderRole()).endTag(NAMESPACE, "providerRole");
        }
        if (cRepository.getProviderHint() != null) {
            serializer.startTag(NAMESPACE, "providerHint").text(cRepository.getProviderHint()).endTag(NAMESPACE, "providerHint");
        }
        if (cRepository.getPathPrefix() != null) {
            serializer.startTag(NAMESPACE, "pathPrefix").text(cRepository.getPathPrefix()).endTag(NAMESPACE, "pathPrefix");
        }
        if (cRepository.getLocalStatus() != null) {
            serializer.startTag(NAMESPACE, "localStatus").text(cRepository.getLocalStatus()).endTag(NAMESPACE, "localStatus");
        }
        if (cRepository.isNotFoundCacheActive()) {
            serializer.startTag(NAMESPACE, "notFoundCacheActive").text(String.valueOf(cRepository.isNotFoundCacheActive())).endTag(NAMESPACE, "notFoundCacheActive");
        }
        if (cRepository.getNotFoundCacheTTL() != 0) {
            serializer.startTag(NAMESPACE, "notFoundCacheTTL").text(String.valueOf(cRepository.getNotFoundCacheTTL())).endTag(NAMESPACE, "notFoundCacheTTL");
        }
        if (cRepository.isUserManaged()) {
            serializer.startTag(NAMESPACE, "userManaged").text(String.valueOf(cRepository.isUserManaged())).endTag(NAMESPACE, "userManaged");
        }
        if (cRepository.isExposed()) {
            serializer.startTag(NAMESPACE, "exposed").text(String.valueOf(cRepository.isExposed())).endTag(NAMESPACE, "exposed");
        }
        if (cRepository.isBrowseable()) {
            serializer.startTag(NAMESPACE, "browseable").text(String.valueOf(cRepository.isBrowseable())).endTag(NAMESPACE, "browseable");
        }
        if (cRepository.getWritePolicy() != null) {
            serializer.startTag(NAMESPACE, "writePolicy").text(cRepository.getWritePolicy()).endTag(NAMESPACE, "writePolicy");
        }
        if (cRepository.isIndexable()) {
            serializer.startTag(NAMESPACE, "indexable").text(String.valueOf(cRepository.isIndexable())).endTag(NAMESPACE, "indexable");
        }
        if (cRepository.isSearchable()) {
            serializer.startTag(NAMESPACE, "searchable").text(String.valueOf(cRepository.isSearchable())).endTag(NAMESPACE, "searchable");
        }
        if (cRepository.getLocalStorage() != null) {
            this.writeCLocalStorage(cRepository.getLocalStorage(), "localStorage", serializer);
        }
        if (cRepository.getRemoteStorage() != null) {
            this.writeCRemoteStorage(cRepository.getRemoteStorage(), "remoteStorage", serializer);
        }
        if (cRepository.getMirrors() != null && cRepository.getMirrors().size() > 0) {
            serializer.startTag(NAMESPACE, "mirrors");
            for (CMirror o : cRepository.getMirrors()) {
                this.writeCMirror(o, "mirror", serializer);
            }
            serializer.endTag(NAMESPACE, "mirrors");
        }
        if (cRepository.getExternalConfiguration() != null) {
            ((Xpp3Dom)cRepository.getExternalConfiguration()).writeToSerializer(NAMESPACE, serializer);
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeCRepositoryGrouping(CRepositoryGrouping cRepositoryGrouping, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (cRepositoryGrouping.getPathMappings() != null && cRepositoryGrouping.getPathMappings().size() > 0) {
            serializer.startTag(NAMESPACE, "pathMappings");
            for (CPathMappingItem o : cRepositoryGrouping.getPathMappings()) {
                this.writeCPathMappingItem(o, "pathMapping", serializer);
            }
            serializer.endTag(NAMESPACE, "pathMappings");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeCRepositoryTarget(CRepositoryTarget cRepositoryTarget, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (cRepositoryTarget.getId() != null) {
            serializer.startTag(NAMESPACE, "id").text(cRepositoryTarget.getId()).endTag(NAMESPACE, "id");
        }
        if (cRepositoryTarget.getName() != null) {
            serializer.startTag(NAMESPACE, "name").text(cRepositoryTarget.getName()).endTag(NAMESPACE, "name");
        }
        if (cRepositoryTarget.getContentClass() != null) {
            serializer.startTag(NAMESPACE, "contentClass").text(cRepositoryTarget.getContentClass()).endTag(NAMESPACE, "contentClass");
        }
        if (cRepositoryTarget.getPatterns() != null && cRepositoryTarget.getPatterns().size() > 0) {
            serializer.startTag(NAMESPACE, "patterns");
            for (String pattern : cRepositoryTarget.getPatterns()) {
                serializer.startTag(NAMESPACE, "pattern").text(pattern).endTag(NAMESPACE, "pattern");
            }
            serializer.endTag(NAMESPACE, "patterns");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeCRestApiSettings(CRestApiSettings cRestApiSettings, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (cRestApiSettings.getBaseUrl() != null) {
            serializer.startTag(NAMESPACE, "baseUrl").text(cRestApiSettings.getBaseUrl()).endTag(NAMESPACE, "baseUrl");
        }
        if (cRestApiSettings.isForceBaseUrl()) {
            serializer.startTag(NAMESPACE, "forceBaseUrl").text(String.valueOf(cRestApiSettings.isForceBaseUrl())).endTag(NAMESPACE, "forceBaseUrl");
        }
        if (cRestApiSettings.getUiTimeout() != 0) {
            serializer.startTag(NAMESPACE, "uiTimeout").text(String.valueOf(cRestApiSettings.getUiTimeout())).endTag(NAMESPACE, "uiTimeout");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeCRouting(CRouting cRouting, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (cRouting.isResolveLinks()) {
            serializer.startTag(NAMESPACE, "resolveLinks").text(String.valueOf(cRouting.isResolveLinks())).endTag(NAMESPACE, "resolveLinks");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeCScheduleConfig(CScheduleConfig cScheduleConfig, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (cScheduleConfig.getType() != null) {
            serializer.startTag(NAMESPACE, "type").text(cScheduleConfig.getType()).endTag(NAMESPACE, "type");
        }
        if (cScheduleConfig.getStartDate() != 0L) {
            serializer.startTag(NAMESPACE, "startDate").text(String.valueOf(cScheduleConfig.getStartDate())).endTag(NAMESPACE, "startDate");
        }
        if (cScheduleConfig.getEndDate() != 0L) {
            serializer.startTag(NAMESPACE, "endDate").text(String.valueOf(cScheduleConfig.getEndDate())).endTag(NAMESPACE, "endDate");
        }
        if (cScheduleConfig.getDaysOfWeek() != null && cScheduleConfig.getDaysOfWeek().size() > 0) {
            serializer.startTag(NAMESPACE, "daysOfWeek");
            for (String daysOfWeek : cScheduleConfig.getDaysOfWeek()) {
                serializer.startTag(NAMESPACE, "daysOfWeek").text(daysOfWeek).endTag(NAMESPACE, "daysOfWeek");
            }
            serializer.endTag(NAMESPACE, "daysOfWeek");
        }
        if (cScheduleConfig.getDaysOfMonth() != null && cScheduleConfig.getDaysOfMonth().size() > 0) {
            serializer.startTag(NAMESPACE, "daysOfMonth");
            for (String daysOfMonth : cScheduleConfig.getDaysOfMonth()) {
                serializer.startTag(NAMESPACE, "daysOfMonth").text(daysOfMonth).endTag(NAMESPACE, "daysOfMonth");
            }
            serializer.endTag(NAMESPACE, "daysOfMonth");
        }
        if (cScheduleConfig.getCronCommand() != null) {
            serializer.startTag(NAMESPACE, "cronCommand").text(cScheduleConfig.getCronCommand()).endTag(NAMESPACE, "cronCommand");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeCScheduledTask(CScheduledTask cScheduledTask, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (cScheduledTask.getId() != null) {
            serializer.startTag(NAMESPACE, "id").text(cScheduledTask.getId()).endTag(NAMESPACE, "id");
        }
        if (cScheduledTask.getName() != null) {
            serializer.startTag(NAMESPACE, "name").text(cScheduledTask.getName()).endTag(NAMESPACE, "name");
        }
        if (cScheduledTask.isEnabled()) {
            serializer.startTag(NAMESPACE, "enabled").text(String.valueOf(cScheduledTask.isEnabled())).endTag(NAMESPACE, "enabled");
        }
        if (cScheduledTask.getType() != null) {
            serializer.startTag(NAMESPACE, "type").text(cScheduledTask.getType()).endTag(NAMESPACE, "type");
        }
        if (cScheduledTask.getStatus() != null) {
            serializer.startTag(NAMESPACE, "status").text(cScheduledTask.getStatus()).endTag(NAMESPACE, "status");
        }
        if (cScheduledTask.getLastRun() != 0L) {
            serializer.startTag(NAMESPACE, "lastRun").text(String.valueOf(cScheduledTask.getLastRun())).endTag(NAMESPACE, "lastRun");
        }
        if (cScheduledTask.getNextRun() != 0L) {
            serializer.startTag(NAMESPACE, "nextRun").text(String.valueOf(cScheduledTask.getNextRun())).endTag(NAMESPACE, "nextRun");
        }
        if (cScheduledTask.getSchedule() != null) {
            this.writeCScheduleConfig(cScheduledTask.getSchedule(), "schedule", serializer);
        }
        if (cScheduledTask.getProperties() != null && cScheduledTask.getProperties().size() > 0) {
            serializer.startTag(NAMESPACE, "properties");
            for (CProps o : cScheduledTask.getProperties()) {
                this.writeCProps(o, "property", serializer);
            }
            serializer.endTag(NAMESPACE, "properties");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeCSmtpConfiguration(CSmtpConfiguration cSmtpConfiguration, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (cSmtpConfiguration.getHostname() != null) {
            serializer.startTag(NAMESPACE, "hostname").text(cSmtpConfiguration.getHostname()).endTag(NAMESPACE, "hostname");
        }
        if (cSmtpConfiguration.getPort() != 0) {
            serializer.startTag(NAMESPACE, "port").text(String.valueOf(cSmtpConfiguration.getPort())).endTag(NAMESPACE, "port");
        }
        if (cSmtpConfiguration.isSslEnabled()) {
            serializer.startTag(NAMESPACE, "sslEnabled").text(String.valueOf(cSmtpConfiguration.isSslEnabled())).endTag(NAMESPACE, "sslEnabled");
        }
        if (cSmtpConfiguration.isTlsEnabled()) {
            serializer.startTag(NAMESPACE, "tlsEnabled").text(String.valueOf(cSmtpConfiguration.isTlsEnabled())).endTag(NAMESPACE, "tlsEnabled");
        }
        if (cSmtpConfiguration.getUsername() != null) {
            serializer.startTag(NAMESPACE, "username").text(cSmtpConfiguration.getUsername()).endTag(NAMESPACE, "username");
        }
        if (cSmtpConfiguration.getPassword() != null) {
            serializer.startTag(NAMESPACE, "password").text(cSmtpConfiguration.getPassword()).endTag(NAMESPACE, "password");
        }
        if (cSmtpConfiguration.isDebugMode()) {
            serializer.startTag(NAMESPACE, "debugMode").text(String.valueOf(cSmtpConfiguration.isDebugMode())).endTag(NAMESPACE, "debugMode");
        }
        if (cSmtpConfiguration.getSystemEmailAddress() != null) {
            serializer.startTag(NAMESPACE, "systemEmailAddress").text(cSmtpConfiguration.getSystemEmailAddress()).endTag(NAMESPACE, "systemEmailAddress");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeConfiguration(Configuration configuration, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (configuration.getVersion() != null) {
            serializer.startTag(NAMESPACE, "version").text(configuration.getVersion()).endTag(NAMESPACE, "version");
        }
        if (configuration.getNexusVersion() != null) {
            serializer.startTag(NAMESPACE, "nexusVersion").text(configuration.getNexusVersion()).endTag(NAMESPACE, "nexusVersion");
        }
        if (configuration.getGlobalConnectionSettings() != null) {
            this.writeCRemoteConnectionSettings(configuration.getGlobalConnectionSettings(), "globalConnectionSettings", serializer);
        }
        if (configuration.getRemoteProxySettings() != null) {
            this.writeCRemoteProxySettings(configuration.getRemoteProxySettings(), "remoteProxySettings", serializer);
        }
        if (configuration.getRestApi() != null) {
            this.writeCRestApiSettings(configuration.getRestApi(), "restApi", serializer);
        }
        if (configuration.getHttpProxy() != null) {
            this.writeCHttpProxySettings(configuration.getHttpProxy(), "httpProxy", serializer);
        }
        if (configuration.getRouting() != null) {
            this.writeCRouting(configuration.getRouting(), "routing", serializer);
        }
        if (configuration.getRepositories() != null && configuration.getRepositories().size() > 0) {
            serializer.startTag(NAMESPACE, "repositories");
            for (CRepository cRepository : configuration.getRepositories()) {
                this.writeCRepository(cRepository, "repository", serializer);
            }
            serializer.endTag(NAMESPACE, "repositories");
        }
        if (configuration.getRepositoryGrouping() != null) {
            this.writeCRepositoryGrouping(configuration.getRepositoryGrouping(), "repositoryGrouping", serializer);
        }
        if (configuration.getRemoteNexusInstances() != null && configuration.getRemoteNexusInstances().size() > 0) {
            serializer.startTag(NAMESPACE, "remoteNexusInstances");
            for (CRemoteNexusInstance cRemoteNexusInstance : configuration.getRemoteNexusInstances()) {
                this.writeCRemoteNexusInstance(cRemoteNexusInstance, "remoteNexusInstance", serializer);
            }
            serializer.endTag(NAMESPACE, "remoteNexusInstances");
        }
        if (configuration.getRepositoryTargets() != null && configuration.getRepositoryTargets().size() > 0) {
            serializer.startTag(NAMESPACE, "repositoryTargets");
            for (CRepositoryTarget cRepositoryTarget : configuration.getRepositoryTargets()) {
                this.writeCRepositoryTarget(cRepositoryTarget, "repositoryTarget", serializer);
            }
            serializer.endTag(NAMESPACE, "repositoryTargets");
        }
        if (configuration.getTasks() != null && configuration.getTasks().size() > 0) {
            serializer.startTag(NAMESPACE, "tasks");
            for (CScheduledTask cScheduledTask : configuration.getTasks()) {
                this.writeCScheduledTask(cScheduledTask, "task", serializer);
            }
            serializer.endTag(NAMESPACE, "tasks");
        }
        if (configuration.getSmtpConfiguration() != null) {
            this.writeCSmtpConfiguration(configuration.getSmtpConfiguration(), "smtpConfiguration", serializer);
        }
        if (configuration.getErrorReporting() != null) {
            this.writeCErrorReporting(configuration.getErrorReporting(), "errorReporting", serializer);
        }
        if (configuration.getPlugins() != null && configuration.getPlugins().size() > 0) {
            serializer.startTag(NAMESPACE, "plugins");
            for (CPlugin cPlugin : configuration.getPlugins()) {
                this.writeCPlugin(cPlugin, "plugin", serializer);
            }
            serializer.endTag(NAMESPACE, "plugins");
        }
        if (configuration.getNotification() != null) {
            this.writeCNotification(configuration.getNotification(), "notification", serializer);
        }
        serializer.endTag(NAMESPACE, tagName);
    }
}

