/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.configuration.model.v2_2_0.io.xpp3;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.sonatype.nexus.configuration.model.v2_2_0.CErrorReporting;
import org.sonatype.nexus.configuration.model.v2_2_0.CHttpProxySettings;
import org.sonatype.nexus.configuration.model.v2_2_0.CLocalStorage;
import org.sonatype.nexus.configuration.model.v2_2_0.CMirror;
import org.sonatype.nexus.configuration.model.v2_2_0.CNotification;
import org.sonatype.nexus.configuration.model.v2_2_0.CNotificationTarget;
import org.sonatype.nexus.configuration.model.v2_2_0.CPathMappingItem;
import org.sonatype.nexus.configuration.model.v2_2_0.CPlugin;
import org.sonatype.nexus.configuration.model.v2_2_0.CProps;
import org.sonatype.nexus.configuration.model.v2_2_0.CRemoteAuthentication;
import org.sonatype.nexus.configuration.model.v2_2_0.CRemoteConnectionSettings;
import org.sonatype.nexus.configuration.model.v2_2_0.CRemoteHttpProxySettings;
import org.sonatype.nexus.configuration.model.v2_2_0.CRemoteNexusInstance;
import org.sonatype.nexus.configuration.model.v2_2_0.CRemoteStorage;
import org.sonatype.nexus.configuration.model.v2_2_0.CRepository;
import org.sonatype.nexus.configuration.model.v2_2_0.CRepositoryGrouping;
import org.sonatype.nexus.configuration.model.v2_2_0.CRepositoryTarget;
import org.sonatype.nexus.configuration.model.v2_2_0.CRestApiSettings;
import org.sonatype.nexus.configuration.model.v2_2_0.CRouting;
import org.sonatype.nexus.configuration.model.v2_2_0.CScheduleConfig;
import org.sonatype.nexus.configuration.model.v2_2_0.CScheduledTask;
import org.sonatype.nexus.configuration.model.v2_2_0.CSmtpConfiguration;
import org.sonatype.nexus.configuration.model.v2_2_0.Configuration;

public class NexusConfigurationXpp3Reader {
    private boolean addDefaultEntities = true;

    private boolean checkFieldWithDuplicate(XmlPullParser parser, String tagName, String alias, Set parsed) throws XmlPullParserException {
        if (!parser.getName().equals(tagName) && !parser.getName().equals(alias)) {
            return false;
        }
        if (!parsed.add(tagName)) {
            throw new XmlPullParserException("Duplicated tag: '" + tagName + "'", parser, null);
        }
        return true;
    }

    private void checkUnknownAttribute(XmlPullParser parser, String attribute, String tagName, boolean strict) throws XmlPullParserException, IOException {
        if (strict) {
            throw new XmlPullParserException("Unknown attribute '" + attribute + "' for tag '" + tagName + "'", parser, null);
        }
    }

    private void checkUnknownElement(XmlPullParser parser, boolean strict) throws XmlPullParserException, IOException {
        if (strict) {
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        int unrecognizedTagCount = 1;
        while (unrecognizedTagCount > 0) {
            int eventType = parser.next();
            if (eventType == 2) {
                ++unrecognizedTagCount;
                continue;
            }
            if (eventType != 3) continue;
            --unrecognizedTagCount;
        }
    }

    public boolean getAddDefaultEntities() {
        return this.addDefaultEntities;
    }

    private boolean getBooleanValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        return this.getBooleanValue(s, attribute, parser, null);
    }

    private boolean getBooleanValue(String s, String attribute, XmlPullParser parser, String defaultValue) throws XmlPullParserException {
        if (s != null && s.length() != 0) {
            return Boolean.valueOf(s);
        }
        if (defaultValue != null) {
            return Boolean.valueOf(defaultValue);
        }
        return false;
    }

    private byte getByteValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Byte.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a byte", parser, (Throwable)nfe);
                }
            }
        }
        return 0;
    }

    private char getCharacterValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        if (s != null) {
            return s.charAt(0);
        }
        return '\u0000';
    }

    private Date getDateValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        return this.getDateValue(s, attribute, null, parser);
    }

    private Date getDateValue(String s, String attribute, String dateFormat, XmlPullParser parser) throws XmlPullParserException {
        if (s != null) {
            String effectiveDateFormat = dateFormat;
            if (dateFormat == null) {
                effectiveDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS";
            }
            if ("long".equals(effectiveDateFormat)) {
                try {
                    return new Date(Long.parseLong(s));
                }
                catch (NumberFormatException e) {
                    throw new XmlPullParserException(e.getMessage(), parser, (Throwable)e);
                }
            }
            try {
                SimpleDateFormat dateParser = new SimpleDateFormat(effectiveDateFormat, Locale.US);
                return dateParser.parse(s);
            }
            catch (ParseException e) {
                throw new XmlPullParserException(e.getMessage(), parser, (Throwable)e);
            }
        }
        return null;
    }

    private double getDoubleValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Double.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a floating point number", parser, (Throwable)nfe);
                }
            }
        }
        return 0.0;
    }

    private float getFloatValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Float.valueOf(s).floatValue();
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a floating point number", parser, (Throwable)nfe);
                }
            }
        }
        return 0.0f;
    }

    private int getIntegerValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Integer.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be an integer", parser, (Throwable)nfe);
                }
            }
        }
        return 0;
    }

    private long getLongValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Long.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a long integer", parser, (Throwable)nfe);
                }
            }
        }
        return 0L;
    }

    private String getRequiredAttributeValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        if (s == null && strict) {
            throw new XmlPullParserException("Missing required value for attribute '" + attribute + "'", parser, null);
        }
        return s;
    }

    private short getShortValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Short.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a short integer", parser, (Throwable)nfe);
                }
            }
        }
        return 0;
    }

    private String getTrimmedValue(String s) {
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    private void initParser(XmlPullParser parser) throws XmlPullParserException {
        if (this.addDefaultEntities) {
            parser.defineEntityReplacementText("nbsp", "\u00a0");
            parser.defineEntityReplacementText("iexcl", "\u00a1");
            parser.defineEntityReplacementText("cent", "\u00a2");
            parser.defineEntityReplacementText("pound", "\u00a3");
            parser.defineEntityReplacementText("curren", "\u00a4");
            parser.defineEntityReplacementText("yen", "\u00a5");
            parser.defineEntityReplacementText("brvbar", "\u00a6");
            parser.defineEntityReplacementText("sect", "\u00a7");
            parser.defineEntityReplacementText("uml", "\u00a8");
            parser.defineEntityReplacementText("copy", "\u00a9");
            parser.defineEntityReplacementText("ordf", "\u00aa");
            parser.defineEntityReplacementText("laquo", "\u00ab");
            parser.defineEntityReplacementText("not", "\u00ac");
            parser.defineEntityReplacementText("shy", "\u00ad");
            parser.defineEntityReplacementText("reg", "\u00ae");
            parser.defineEntityReplacementText("macr", "\u00af");
            parser.defineEntityReplacementText("deg", "\u00b0");
            parser.defineEntityReplacementText("plusmn", "\u00b1");
            parser.defineEntityReplacementText("sup2", "\u00b2");
            parser.defineEntityReplacementText("sup3", "\u00b3");
            parser.defineEntityReplacementText("acute", "\u00b4");
            parser.defineEntityReplacementText("micro", "\u00b5");
            parser.defineEntityReplacementText("para", "\u00b6");
            parser.defineEntityReplacementText("middot", "\u00b7");
            parser.defineEntityReplacementText("cedil", "\u00b8");
            parser.defineEntityReplacementText("sup1", "\u00b9");
            parser.defineEntityReplacementText("ordm", "\u00ba");
            parser.defineEntityReplacementText("raquo", "\u00bb");
            parser.defineEntityReplacementText("frac14", "\u00bc");
            parser.defineEntityReplacementText("frac12", "\u00bd");
            parser.defineEntityReplacementText("frac34", "\u00be");
            parser.defineEntityReplacementText("iquest", "\u00bf");
            parser.defineEntityReplacementText("Agrave", "\u00c0");
            parser.defineEntityReplacementText("Aacute", "\u00c1");
            parser.defineEntityReplacementText("Acirc", "\u00c2");
            parser.defineEntityReplacementText("Atilde", "\u00c3");
            parser.defineEntityReplacementText("Auml", "\u00c4");
            parser.defineEntityReplacementText("Aring", "\u00c5");
            parser.defineEntityReplacementText("AElig", "\u00c6");
            parser.defineEntityReplacementText("Ccedil", "\u00c7");
            parser.defineEntityReplacementText("Egrave", "\u00c8");
            parser.defineEntityReplacementText("Eacute", "\u00c9");
            parser.defineEntityReplacementText("Ecirc", "\u00ca");
            parser.defineEntityReplacementText("Euml", "\u00cb");
            parser.defineEntityReplacementText("Igrave", "\u00cc");
            parser.defineEntityReplacementText("Iacute", "\u00cd");
            parser.defineEntityReplacementText("Icirc", "\u00ce");
            parser.defineEntityReplacementText("Iuml", "\u00cf");
            parser.defineEntityReplacementText("ETH", "\u00d0");
            parser.defineEntityReplacementText("Ntilde", "\u00d1");
            parser.defineEntityReplacementText("Ograve", "\u00d2");
            parser.defineEntityReplacementText("Oacute", "\u00d3");
            parser.defineEntityReplacementText("Ocirc", "\u00d4");
            parser.defineEntityReplacementText("Otilde", "\u00d5");
            parser.defineEntityReplacementText("Ouml", "\u00d6");
            parser.defineEntityReplacementText("times", "\u00d7");
            parser.defineEntityReplacementText("Oslash", "\u00d8");
            parser.defineEntityReplacementText("Ugrave", "\u00d9");
            parser.defineEntityReplacementText("Uacute", "\u00da");
            parser.defineEntityReplacementText("Ucirc", "\u00db");
            parser.defineEntityReplacementText("Uuml", "\u00dc");
            parser.defineEntityReplacementText("Yacute", "\u00dd");
            parser.defineEntityReplacementText("THORN", "\u00de");
            parser.defineEntityReplacementText("szlig", "\u00df");
            parser.defineEntityReplacementText("agrave", "\u00e0");
            parser.defineEntityReplacementText("aacute", "\u00e1");
            parser.defineEntityReplacementText("acirc", "\u00e2");
            parser.defineEntityReplacementText("atilde", "\u00e3");
            parser.defineEntityReplacementText("auml", "\u00e4");
            parser.defineEntityReplacementText("aring", "\u00e5");
            parser.defineEntityReplacementText("aelig", "\u00e6");
            parser.defineEntityReplacementText("ccedil", "\u00e7");
            parser.defineEntityReplacementText("egrave", "\u00e8");
            parser.defineEntityReplacementText("eacute", "\u00e9");
            parser.defineEntityReplacementText("ecirc", "\u00ea");
            parser.defineEntityReplacementText("euml", "\u00eb");
            parser.defineEntityReplacementText("igrave", "\u00ec");
            parser.defineEntityReplacementText("iacute", "\u00ed");
            parser.defineEntityReplacementText("icirc", "\u00ee");
            parser.defineEntityReplacementText("iuml", "\u00ef");
            parser.defineEntityReplacementText("eth", "\u00f0");
            parser.defineEntityReplacementText("ntilde", "\u00f1");
            parser.defineEntityReplacementText("ograve", "\u00f2");
            parser.defineEntityReplacementText("oacute", "\u00f3");
            parser.defineEntityReplacementText("ocirc", "\u00f4");
            parser.defineEntityReplacementText("otilde", "\u00f5");
            parser.defineEntityReplacementText("ouml", "\u00f6");
            parser.defineEntityReplacementText("divide", "\u00f7");
            parser.defineEntityReplacementText("oslash", "\u00f8");
            parser.defineEntityReplacementText("ugrave", "\u00f9");
            parser.defineEntityReplacementText("uacute", "\u00fa");
            parser.defineEntityReplacementText("ucirc", "\u00fb");
            parser.defineEntityReplacementText("uuml", "\u00fc");
            parser.defineEntityReplacementText("yacute", "\u00fd");
            parser.defineEntityReplacementText("thorn", "\u00fe");
            parser.defineEntityReplacementText("yuml", "\u00ff");
            parser.defineEntityReplacementText("OElig", "\u0152");
            parser.defineEntityReplacementText("oelig", "\u0153");
            parser.defineEntityReplacementText("Scaron", "\u0160");
            parser.defineEntityReplacementText("scaron", "\u0161");
            parser.defineEntityReplacementText("Yuml", "\u0178");
            parser.defineEntityReplacementText("circ", "\u02c6");
            parser.defineEntityReplacementText("tilde", "\u02dc");
            parser.defineEntityReplacementText("ensp", "\u2002");
            parser.defineEntityReplacementText("emsp", "\u2003");
            parser.defineEntityReplacementText("thinsp", "\u2009");
            parser.defineEntityReplacementText("zwnj", "\u200c");
            parser.defineEntityReplacementText("zwj", "\u200d");
            parser.defineEntityReplacementText("lrm", "\u200e");
            parser.defineEntityReplacementText("rlm", "\u200f");
            parser.defineEntityReplacementText("ndash", "\u2013");
            parser.defineEntityReplacementText("mdash", "\u2014");
            parser.defineEntityReplacementText("lsquo", "\u2018");
            parser.defineEntityReplacementText("rsquo", "\u2019");
            parser.defineEntityReplacementText("sbquo", "\u201a");
            parser.defineEntityReplacementText("ldquo", "\u201c");
            parser.defineEntityReplacementText("rdquo", "\u201d");
            parser.defineEntityReplacementText("bdquo", "\u201e");
            parser.defineEntityReplacementText("dagger", "\u2020");
            parser.defineEntityReplacementText("Dagger", "\u2021");
            parser.defineEntityReplacementText("permil", "\u2030");
            parser.defineEntityReplacementText("lsaquo", "\u2039");
            parser.defineEntityReplacementText("rsaquo", "\u203a");
            parser.defineEntityReplacementText("euro", "\u20ac");
            parser.defineEntityReplacementText("fnof", "\u0192");
            parser.defineEntityReplacementText("Alpha", "\u0391");
            parser.defineEntityReplacementText("Beta", "\u0392");
            parser.defineEntityReplacementText("Gamma", "\u0393");
            parser.defineEntityReplacementText("Delta", "\u0394");
            parser.defineEntityReplacementText("Epsilon", "\u0395");
            parser.defineEntityReplacementText("Zeta", "\u0396");
            parser.defineEntityReplacementText("Eta", "\u0397");
            parser.defineEntityReplacementText("Theta", "\u0398");
            parser.defineEntityReplacementText("Iota", "\u0399");
            parser.defineEntityReplacementText("Kappa", "\u039a");
            parser.defineEntityReplacementText("Lambda", "\u039b");
            parser.defineEntityReplacementText("Mu", "\u039c");
            parser.defineEntityReplacementText("Nu", "\u039d");
            parser.defineEntityReplacementText("Xi", "\u039e");
            parser.defineEntityReplacementText("Omicron", "\u039f");
            parser.defineEntityReplacementText("Pi", "\u03a0");
            parser.defineEntityReplacementText("Rho", "\u03a1");
            parser.defineEntityReplacementText("Sigma", "\u03a3");
            parser.defineEntityReplacementText("Tau", "\u03a4");
            parser.defineEntityReplacementText("Upsilon", "\u03a5");
            parser.defineEntityReplacementText("Phi", "\u03a6");
            parser.defineEntityReplacementText("Chi", "\u03a7");
            parser.defineEntityReplacementText("Psi", "\u03a8");
            parser.defineEntityReplacementText("Omega", "\u03a9");
            parser.defineEntityReplacementText("alpha", "\u03b1");
            parser.defineEntityReplacementText("beta", "\u03b2");
            parser.defineEntityReplacementText("gamma", "\u03b3");
            parser.defineEntityReplacementText("delta", "\u03b4");
            parser.defineEntityReplacementText("epsilon", "\u03b5");
            parser.defineEntityReplacementText("zeta", "\u03b6");
            parser.defineEntityReplacementText("eta", "\u03b7");
            parser.defineEntityReplacementText("theta", "\u03b8");
            parser.defineEntityReplacementText("iota", "\u03b9");
            parser.defineEntityReplacementText("kappa", "\u03ba");
            parser.defineEntityReplacementText("lambda", "\u03bb");
            parser.defineEntityReplacementText("mu", "\u03bc");
            parser.defineEntityReplacementText("nu", "\u03bd");
            parser.defineEntityReplacementText("xi", "\u03be");
            parser.defineEntityReplacementText("omicron", "\u03bf");
            parser.defineEntityReplacementText("pi", "\u03c0");
            parser.defineEntityReplacementText("rho", "\u03c1");
            parser.defineEntityReplacementText("sigmaf", "\u03c2");
            parser.defineEntityReplacementText("sigma", "\u03c3");
            parser.defineEntityReplacementText("tau", "\u03c4");
            parser.defineEntityReplacementText("upsilon", "\u03c5");
            parser.defineEntityReplacementText("phi", "\u03c6");
            parser.defineEntityReplacementText("chi", "\u03c7");
            parser.defineEntityReplacementText("psi", "\u03c8");
            parser.defineEntityReplacementText("omega", "\u03c9");
            parser.defineEntityReplacementText("thetasym", "\u03d1");
            parser.defineEntityReplacementText("upsih", "\u03d2");
            parser.defineEntityReplacementText("piv", "\u03d6");
            parser.defineEntityReplacementText("bull", "\u2022");
            parser.defineEntityReplacementText("hellip", "\u2026");
            parser.defineEntityReplacementText("prime", "\u2032");
            parser.defineEntityReplacementText("Prime", "\u2033");
            parser.defineEntityReplacementText("oline", "\u203e");
            parser.defineEntityReplacementText("frasl", "\u2044");
            parser.defineEntityReplacementText("weierp", "\u2118");
            parser.defineEntityReplacementText("image", "\u2111");
            parser.defineEntityReplacementText("real", "\u211c");
            parser.defineEntityReplacementText("trade", "\u2122");
            parser.defineEntityReplacementText("alefsym", "\u2135");
            parser.defineEntityReplacementText("larr", "\u2190");
            parser.defineEntityReplacementText("uarr", "\u2191");
            parser.defineEntityReplacementText("rarr", "\u2192");
            parser.defineEntityReplacementText("darr", "\u2193");
            parser.defineEntityReplacementText("harr", "\u2194");
            parser.defineEntityReplacementText("crarr", "\u21b5");
            parser.defineEntityReplacementText("lArr", "\u21d0");
            parser.defineEntityReplacementText("uArr", "\u21d1");
            parser.defineEntityReplacementText("rArr", "\u21d2");
            parser.defineEntityReplacementText("dArr", "\u21d3");
            parser.defineEntityReplacementText("hArr", "\u21d4");
            parser.defineEntityReplacementText("forall", "\u2200");
            parser.defineEntityReplacementText("part", "\u2202");
            parser.defineEntityReplacementText("exist", "\u2203");
            parser.defineEntityReplacementText("empty", "\u2205");
            parser.defineEntityReplacementText("nabla", "\u2207");
            parser.defineEntityReplacementText("isin", "\u2208");
            parser.defineEntityReplacementText("notin", "\u2209");
            parser.defineEntityReplacementText("ni", "\u220b");
            parser.defineEntityReplacementText("prod", "\u220f");
            parser.defineEntityReplacementText("sum", "\u2211");
            parser.defineEntityReplacementText("minus", "\u2212");
            parser.defineEntityReplacementText("lowast", "\u2217");
            parser.defineEntityReplacementText("radic", "\u221a");
            parser.defineEntityReplacementText("prop", "\u221d");
            parser.defineEntityReplacementText("infin", "\u221e");
            parser.defineEntityReplacementText("ang", "\u2220");
            parser.defineEntityReplacementText("and", "\u2227");
            parser.defineEntityReplacementText("or", "\u2228");
            parser.defineEntityReplacementText("cap", "\u2229");
            parser.defineEntityReplacementText("cup", "\u222a");
            parser.defineEntityReplacementText("int", "\u222b");
            parser.defineEntityReplacementText("there4", "\u2234");
            parser.defineEntityReplacementText("sim", "\u223c");
            parser.defineEntityReplacementText("cong", "\u2245");
            parser.defineEntityReplacementText("asymp", "\u2248");
            parser.defineEntityReplacementText("ne", "\u2260");
            parser.defineEntityReplacementText("equiv", "\u2261");
            parser.defineEntityReplacementText("le", "\u2264");
            parser.defineEntityReplacementText("ge", "\u2265");
            parser.defineEntityReplacementText("sub", "\u2282");
            parser.defineEntityReplacementText("sup", "\u2283");
            parser.defineEntityReplacementText("nsub", "\u2284");
            parser.defineEntityReplacementText("sube", "\u2286");
            parser.defineEntityReplacementText("supe", "\u2287");
            parser.defineEntityReplacementText("oplus", "\u2295");
            parser.defineEntityReplacementText("otimes", "\u2297");
            parser.defineEntityReplacementText("perp", "\u22a5");
            parser.defineEntityReplacementText("sdot", "\u22c5");
            parser.defineEntityReplacementText("lceil", "\u2308");
            parser.defineEntityReplacementText("rceil", "\u2309");
            parser.defineEntityReplacementText("lfloor", "\u230a");
            parser.defineEntityReplacementText("rfloor", "\u230b");
            parser.defineEntityReplacementText("lang", "\u2329");
            parser.defineEntityReplacementText("rang", "\u232a");
            parser.defineEntityReplacementText("loz", "\u25ca");
            parser.defineEntityReplacementText("spades", "\u2660");
            parser.defineEntityReplacementText("clubs", "\u2663");
            parser.defineEntityReplacementText("hearts", "\u2665");
            parser.defineEntityReplacementText("diams", "\u2666");
        }
    }

    private int nextTag(XmlPullParser parser) throws IOException, XmlPullParserException {
        int eventType = parser.next();
        if (eventType == 4) {
            eventType = parser.next();
        }
        if (eventType != 2 && eventType != 3) {
            throw new XmlPullParserException("expected START_TAG or END_TAG not " + XmlPullParser.TYPES[eventType], parser, null);
        }
        return eventType;
    }

    public Configuration read(Reader reader, boolean strict) throws IOException, XmlPullParserException {
        MXParser parser = new MXParser();
        parser.setInput(reader);
        this.initParser((XmlPullParser)parser);
        return this.read((XmlPullParser)parser, strict);
    }

    public Configuration read(Reader reader) throws IOException, XmlPullParserException {
        return this.read(reader, true);
    }

    public Configuration read(InputStream in, boolean strict) throws IOException, XmlPullParserException {
        return this.read((Reader)ReaderFactory.newXmlReader((InputStream)in), strict);
    }

    public Configuration read(InputStream in) throws IOException, XmlPullParserException {
        return this.read((Reader)ReaderFactory.newXmlReader((InputStream)in));
    }

    private CErrorReporting parseCErrorReporting(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        CErrorReporting cErrorReporting = new CErrorReporting();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "enabled", null, parsed)) {
                cErrorReporting.setEnabled(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "enabled", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "jiraUrl", null, parsed)) {
                cErrorReporting.setJiraUrl(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "jiraProject", null, parsed)) {
                cErrorReporting.setJiraProject(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "jiraUsername", null, parsed)) {
                cErrorReporting.setJiraUsername(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "jiraPassword", null, parsed)) {
                cErrorReporting.setJiraPassword(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "useGlobalProxy", null, parsed)) {
                cErrorReporting.setUseGlobalProxy(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "useGlobalProxy", parser, "false"));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return cErrorReporting;
    }

    private CHttpProxySettings parseCHttpProxySettings(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        CHttpProxySettings cHttpProxySettings = new CHttpProxySettings();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "enabled", null, parsed)) {
                cHttpProxySettings.setEnabled(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "enabled", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "port", null, parsed)) {
                cHttpProxySettings.setPort(this.getIntegerValue(this.getTrimmedValue(parser.nextText()), "port", parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "proxyPolicy", null, parsed)) {
                cHttpProxySettings.setProxyPolicy(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return cHttpProxySettings;
    }

    private CLocalStorage parseCLocalStorage(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        CLocalStorage cLocalStorage = new CLocalStorage();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "provider", null, parsed)) {
                cLocalStorage.setProvider(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "url", null, parsed)) {
                cLocalStorage.setUrl(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return cLocalStorage;
    }

    private CMirror parseCMirror(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        CMirror cMirror = new CMirror();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "id", null, parsed)) {
                cMirror.setId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "url", null, parsed)) {
                cMirror.setUrl(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return cMirror;
    }

    private CNotification parseCNotification(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        CNotification cNotification = new CNotification();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "enabled", null, parsed)) {
                cNotification.setEnabled(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "enabled", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "notificationTargets", null, parsed)) {
                ArrayList<CNotificationTarget> notificationTargets = new ArrayList<CNotificationTarget>();
                cNotification.setNotificationTargets(notificationTargets);
                while (parser.nextTag() == 2) {
                    if ("notificationTarget".equals(parser.getName())) {
                        notificationTargets.add(this.parseCNotificationTarget(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return cNotification;
    }

    private CNotificationTarget parseCNotificationTarget(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        CNotificationTarget cNotificationTarget = new CNotificationTarget();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "targetId", null, parsed)) {
                cNotificationTarget.setTargetId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "targetRoles", null, parsed)) {
                ArrayList<String> targetRoles = new ArrayList<String>();
                cNotificationTarget.setTargetRoles(targetRoles);
                while (parser.nextTag() == 2) {
                    if ("targetRole".equals(parser.getName())) {
                        targetRoles.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "targetUsers", null, parsed)) {
                ArrayList<String> targetUsers = new ArrayList<String>();
                cNotificationTarget.setTargetUsers(targetUsers);
                while (parser.nextTag() == 2) {
                    if ("targetUser".equals(parser.getName())) {
                        targetUsers.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "targetExternals", null, parsed)) {
                ArrayList<String> targetExternals = new ArrayList<String>();
                cNotificationTarget.setTargetExternals(targetExternals);
                while (parser.nextTag() == 2) {
                    if ("targetExternal".equals(parser.getName())) {
                        targetExternals.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return cNotificationTarget;
    }

    private CPathMappingItem parseCPathMappingItem(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        CPathMappingItem cPathMappingItem = new CPathMappingItem();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "id", null, parsed)) {
                cPathMappingItem.setId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "groupId", null, parsed)) {
                cPathMappingItem.setGroupId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "routeType", null, parsed)) {
                cPathMappingItem.setRouteType(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "routePatterns", null, parsed)) {
                ArrayList<String> routePatterns = new ArrayList<String>();
                cPathMappingItem.setRoutePatterns(routePatterns);
                while (parser.nextTag() == 2) {
                    if ("routePattern".equals(parser.getName())) {
                        routePatterns.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "repositories", null, parsed)) {
                ArrayList<String> repositories = new ArrayList<String>();
                cPathMappingItem.setRepositories(repositories);
                while (parser.nextTag() == 2) {
                    if ("repository".equals(parser.getName())) {
                        repositories.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return cPathMappingItem;
    }

    private CPlugin parseCPlugin(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        CPlugin cPlugin = new CPlugin();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "type", null, parsed)) {
                cPlugin.setType(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "id", null, parsed)) {
                cPlugin.setId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "name", null, parsed)) {
                cPlugin.setName(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "status", null, parsed)) {
                cPlugin.setStatus(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "externalConfiguration", null, parsed)) {
                cPlugin.setExternalConfiguration(Xpp3DomBuilder.build((XmlPullParser)parser, (boolean)true));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return cPlugin;
    }

    private CProps parseCProps(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        CProps cProps = new CProps();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "key", null, parsed)) {
                cProps.setKey(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "value", null, parsed)) {
                cProps.setValue(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return cProps;
    }

    private CRemoteAuthentication parseCRemoteAuthentication(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        CRemoteAuthentication cRemoteAuthentication = new CRemoteAuthentication();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "username", null, parsed)) {
                cRemoteAuthentication.setUsername(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "password", null, parsed)) {
                cRemoteAuthentication.setPassword(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "ntlmHost", null, parsed)) {
                cRemoteAuthentication.setNtlmHost(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "ntlmDomain", null, parsed)) {
                cRemoteAuthentication.setNtlmDomain(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "trustStore", null, parsed)) {
                cRemoteAuthentication.setTrustStore(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "trustStorePassword", null, parsed)) {
                cRemoteAuthentication.setTrustStorePassword(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "keyStore", null, parsed)) {
                cRemoteAuthentication.setKeyStore(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "keyStorePassword", null, parsed)) {
                cRemoteAuthentication.setKeyStorePassword(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return cRemoteAuthentication;
    }

    private CRemoteConnectionSettings parseCRemoteConnectionSettings(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        CRemoteConnectionSettings cRemoteConnectionSettings = new CRemoteConnectionSettings();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "connectionTimeout", null, parsed)) {
                cRemoteConnectionSettings.setConnectionTimeout(this.getIntegerValue(this.getTrimmedValue(parser.nextText()), "connectionTimeout", parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "retrievalRetryCount", null, parsed)) {
                cRemoteConnectionSettings.setRetrievalRetryCount(this.getIntegerValue(this.getTrimmedValue(parser.nextText()), "retrievalRetryCount", parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "queryString", null, parsed)) {
                cRemoteConnectionSettings.setQueryString(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "userAgentCustomizationString", null, parsed)) {
                cRemoteConnectionSettings.setUserAgentCustomizationString(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return cRemoteConnectionSettings;
    }

    private CRemoteHttpProxySettings parseCRemoteHttpProxySettings(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        CRemoteHttpProxySettings cRemoteHttpProxySettings = new CRemoteHttpProxySettings();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "blockInheritance", null, parsed)) {
                cRemoteHttpProxySettings.setBlockInheritance(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "blockInheritance", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "proxyHostname", null, parsed)) {
                cRemoteHttpProxySettings.setProxyHostname(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "proxyPort", null, parsed)) {
                cRemoteHttpProxySettings.setProxyPort(this.getIntegerValue(this.getTrimmedValue(parser.nextText()), "proxyPort", parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "authentication", null, parsed)) {
                cRemoteHttpProxySettings.setAuthentication(this.parseCRemoteAuthentication(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "nonProxyHosts", null, parsed)) {
                ArrayList<String> nonProxyHosts = new ArrayList<String>();
                cRemoteHttpProxySettings.setNonProxyHosts(nonProxyHosts);
                while (parser.nextTag() == 2) {
                    if ("nonProxyHost".equals(parser.getName())) {
                        nonProxyHosts.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return cRemoteHttpProxySettings;
    }

    private CRemoteNexusInstance parseCRemoteNexusInstance(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        CRemoteNexusInstance cRemoteNexusInstance = new CRemoteNexusInstance();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "alias", null, parsed)) {
                cRemoteNexusInstance.setAlias(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "instanceUrl", null, parsed)) {
                cRemoteNexusInstance.setInstanceUrl(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return cRemoteNexusInstance;
    }

    private CRemoteStorage parseCRemoteStorage(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        CRemoteStorage cRemoteStorage = new CRemoteStorage();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "provider", null, parsed)) {
                cRemoteStorage.setProvider(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "url", null, parsed)) {
                cRemoteStorage.setUrl(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "authentication", null, parsed)) {
                cRemoteStorage.setAuthentication(this.parseCRemoteAuthentication(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "connectionSettings", null, parsed)) {
                cRemoteStorage.setConnectionSettings(this.parseCRemoteConnectionSettings(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "inheritHttpProxySettings", null, parsed)) {
                cRemoteStorage.setInheritHttpProxySettings(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "inheritHttpProxySettings", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "httpProxySettings", null, parsed)) {
                cRemoteStorage.setHttpProxySettings(this.parseCRemoteHttpProxySettings(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "mirrors", null, parsed)) {
                ArrayList<CMirror> mirrors = new ArrayList<CMirror>();
                cRemoteStorage.setMirrors(mirrors);
                while (parser.nextTag() == 2) {
                    if ("mirror".equals(parser.getName())) {
                        mirrors.add(this.parseCMirror(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return cRemoteStorage;
    }

    private CRepository parseCRepository(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        CRepository cRepository = new CRepository();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "id", null, parsed)) {
                cRepository.setId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "name", null, parsed)) {
                cRepository.setName(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "providerRole", null, parsed)) {
                cRepository.setProviderRole(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "providerHint", null, parsed)) {
                cRepository.setProviderHint(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "pathPrefix", null, parsed)) {
                cRepository.setPathPrefix(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "localStatus", null, parsed)) {
                cRepository.setLocalStatus(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "notFoundCacheActive", null, parsed)) {
                cRepository.setNotFoundCacheActive(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "notFoundCacheActive", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "notFoundCacheTTL", null, parsed)) {
                cRepository.setNotFoundCacheTTL(this.getIntegerValue(this.getTrimmedValue(parser.nextText()), "notFoundCacheTTL", parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "userManaged", null, parsed)) {
                cRepository.setUserManaged(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "userManaged", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "exposed", null, parsed)) {
                cRepository.setExposed(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "exposed", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "browseable", null, parsed)) {
                cRepository.setBrowseable(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "browseable", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "writePolicy", null, parsed)) {
                cRepository.setWritePolicy(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "indexable", null, parsed)) {
                cRepository.setIndexable(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "indexable", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "searchable", null, parsed)) {
                cRepository.setSearchable(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "searchable", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "localStorage", null, parsed)) {
                cRepository.setLocalStorage(this.parseCLocalStorage(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "remoteStorage", null, parsed)) {
                cRepository.setRemoteStorage(this.parseCRemoteStorage(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "mirrors", null, parsed)) {
                ArrayList<CMirror> mirrors = new ArrayList<CMirror>();
                cRepository.setMirrors(mirrors);
                while (parser.nextTag() == 2) {
                    if ("mirror".equals(parser.getName())) {
                        mirrors.add(this.parseCMirror(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "externalConfiguration", null, parsed)) {
                cRepository.setExternalConfiguration(Xpp3DomBuilder.build((XmlPullParser)parser, (boolean)true));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return cRepository;
    }

    private CRepositoryGrouping parseCRepositoryGrouping(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        CRepositoryGrouping cRepositoryGrouping = new CRepositoryGrouping();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "pathMappings", null, parsed)) {
                ArrayList<CPathMappingItem> pathMappings = new ArrayList<CPathMappingItem>();
                cRepositoryGrouping.setPathMappings(pathMappings);
                while (parser.nextTag() == 2) {
                    if ("pathMapping".equals(parser.getName())) {
                        pathMappings.add(this.parseCPathMappingItem(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return cRepositoryGrouping;
    }

    private CRepositoryTarget parseCRepositoryTarget(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        CRepositoryTarget cRepositoryTarget = new CRepositoryTarget();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "id", null, parsed)) {
                cRepositoryTarget.setId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "name", null, parsed)) {
                cRepositoryTarget.setName(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "contentClass", null, parsed)) {
                cRepositoryTarget.setContentClass(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "patterns", null, parsed)) {
                ArrayList<String> patterns = new ArrayList<String>();
                cRepositoryTarget.setPatterns(patterns);
                while (parser.nextTag() == 2) {
                    if ("pattern".equals(parser.getName())) {
                        patterns.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return cRepositoryTarget;
    }

    private CRestApiSettings parseCRestApiSettings(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        CRestApiSettings cRestApiSettings = new CRestApiSettings();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "baseUrl", null, parsed)) {
                cRestApiSettings.setBaseUrl(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "forceBaseUrl", null, parsed)) {
                cRestApiSettings.setForceBaseUrl(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "forceBaseUrl", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "uiTimeout", null, parsed)) {
                cRestApiSettings.setUiTimeout(this.getIntegerValue(this.getTrimmedValue(parser.nextText()), "uiTimeout", parser, strict));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return cRestApiSettings;
    }

    private CRouting parseCRouting(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        CRouting cRouting = new CRouting();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "resolveLinks", null, parsed)) {
                cRouting.setResolveLinks(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "resolveLinks", parser, "false"));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return cRouting;
    }

    private CScheduleConfig parseCScheduleConfig(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        CScheduleConfig cScheduleConfig = new CScheduleConfig();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "type", null, parsed)) {
                cScheduleConfig.setType(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "startDate", null, parsed)) {
                cScheduleConfig.setStartDate(this.getLongValue(this.getTrimmedValue(parser.nextText()), "startDate", parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "endDate", null, parsed)) {
                cScheduleConfig.setEndDate(this.getLongValue(this.getTrimmedValue(parser.nextText()), "endDate", parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "daysOfWeek", null, parsed)) {
                ArrayList<String> daysOfWeek = new ArrayList<String>();
                cScheduleConfig.setDaysOfWeek(daysOfWeek);
                while (parser.nextTag() == 2) {
                    if ("daysOfWeek".equals(parser.getName())) {
                        daysOfWeek.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "daysOfMonth", null, parsed)) {
                ArrayList<String> daysOfMonth = new ArrayList<String>();
                cScheduleConfig.setDaysOfMonth(daysOfMonth);
                while (parser.nextTag() == 2) {
                    if ("daysOfMonth".equals(parser.getName())) {
                        daysOfMonth.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "cronCommand", null, parsed)) {
                cScheduleConfig.setCronCommand(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return cScheduleConfig;
    }

    private CScheduledTask parseCScheduledTask(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        CScheduledTask cScheduledTask = new CScheduledTask();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "id", null, parsed)) {
                cScheduledTask.setId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "name", null, parsed)) {
                cScheduledTask.setName(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "enabled", null, parsed)) {
                cScheduledTask.setEnabled(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "enabled", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "type", null, parsed)) {
                cScheduledTask.setType(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "status", null, parsed)) {
                cScheduledTask.setStatus(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "lastRun", null, parsed)) {
                cScheduledTask.setLastRun(this.getLongValue(this.getTrimmedValue(parser.nextText()), "lastRun", parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "nextRun", null, parsed)) {
                cScheduledTask.setNextRun(this.getLongValue(this.getTrimmedValue(parser.nextText()), "nextRun", parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "schedule", null, parsed)) {
                cScheduledTask.setSchedule(this.parseCScheduleConfig(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "properties", null, parsed)) {
                ArrayList<CProps> properties = new ArrayList<CProps>();
                cScheduledTask.setProperties(properties);
                while (parser.nextTag() == 2) {
                    if ("property".equals(parser.getName())) {
                        properties.add(this.parseCProps(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return cScheduledTask;
    }

    private CSmtpConfiguration parseCSmtpConfiguration(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        CSmtpConfiguration cSmtpConfiguration = new CSmtpConfiguration();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "hostname", null, parsed)) {
                cSmtpConfiguration.setHostname(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "port", null, parsed)) {
                cSmtpConfiguration.setPort(this.getIntegerValue(this.getTrimmedValue(parser.nextText()), "port", parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "sslEnabled", null, parsed)) {
                cSmtpConfiguration.setSslEnabled(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "sslEnabled", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "tlsEnabled", null, parsed)) {
                cSmtpConfiguration.setTlsEnabled(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "tlsEnabled", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "username", null, parsed)) {
                cSmtpConfiguration.setUsername(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "password", null, parsed)) {
                cSmtpConfiguration.setPassword(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "debugMode", null, parsed)) {
                cSmtpConfiguration.setDebugMode(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "debugMode", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "systemEmailAddress", null, parsed)) {
                cSmtpConfiguration.setSystemEmailAddress(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return cSmtpConfiguration;
    }

    private Configuration parseConfiguration(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Configuration configuration = new Configuration();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0 || "xmlns".equals(name)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "version", null, parsed)) {
                configuration.setVersion(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "nexusVersion", null, parsed)) {
                configuration.setNexusVersion(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "globalConnectionSettings", null, parsed)) {
                configuration.setGlobalConnectionSettings(this.parseCRemoteConnectionSettings(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "globalHttpProxySettings", null, parsed)) {
                configuration.setGlobalHttpProxySettings(this.parseCRemoteHttpProxySettings(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "restApi", null, parsed)) {
                configuration.setRestApi(this.parseCRestApiSettings(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "httpProxy", null, parsed)) {
                configuration.setHttpProxy(this.parseCHttpProxySettings(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "routing", null, parsed)) {
                configuration.setRouting(this.parseCRouting(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "repositories", null, parsed)) {
                ArrayList<CRepository> repositories = new ArrayList<CRepository>();
                configuration.setRepositories(repositories);
                while (parser.nextTag() == 2) {
                    if ("repository".equals(parser.getName())) {
                        repositories.add(this.parseCRepository(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "repositoryGrouping", null, parsed)) {
                configuration.setRepositoryGrouping(this.parseCRepositoryGrouping(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "remoteNexusInstances", null, parsed)) {
                ArrayList<CRemoteNexusInstance> remoteNexusInstances = new ArrayList<CRemoteNexusInstance>();
                configuration.setRemoteNexusInstances(remoteNexusInstances);
                while (parser.nextTag() == 2) {
                    if ("remoteNexusInstance".equals(parser.getName())) {
                        remoteNexusInstances.add(this.parseCRemoteNexusInstance(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "repositoryTargets", null, parsed)) {
                ArrayList<CRepositoryTarget> repositoryTargets = new ArrayList<CRepositoryTarget>();
                configuration.setRepositoryTargets(repositoryTargets);
                while (parser.nextTag() == 2) {
                    if ("repositoryTarget".equals(parser.getName())) {
                        repositoryTargets.add(this.parseCRepositoryTarget(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "tasks", null, parsed)) {
                ArrayList<CScheduledTask> tasks = new ArrayList<CScheduledTask>();
                configuration.setTasks(tasks);
                while (parser.nextTag() == 2) {
                    if ("task".equals(parser.getName())) {
                        tasks.add(this.parseCScheduledTask(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "smtpConfiguration", null, parsed)) {
                configuration.setSmtpConfiguration(this.parseCSmtpConfiguration(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "errorReporting", null, parsed)) {
                configuration.setErrorReporting(this.parseCErrorReporting(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "plugins", null, parsed)) {
                ArrayList<CPlugin> plugins = new ArrayList<CPlugin>();
                configuration.setPlugins(plugins);
                while (parser.nextTag() == 2) {
                    if ("plugin".equals(parser.getName())) {
                        plugins.add(this.parseCPlugin(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "notification", null, parsed)) {
                configuration.setNotification(this.parseCNotification(parser, strict));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return configuration;
    }

    private Configuration read(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        int eventType = parser.getEventType();
        while (eventType != 1) {
            if (eventType == 2) {
                if (strict && !"nexusConfiguration".equals(parser.getName())) {
                    throw new XmlPullParserException("Expected root element 'nexusConfiguration' but found '" + parser.getName() + "'", parser, null);
                }
                Configuration configuration = this.parseConfiguration(parser, strict);
                configuration.setModelEncoding(parser.getInputEncoding());
                return configuration;
            }
            eventType = parser.next();
        }
        throw new XmlPullParserException("Expected root element 'nexusConfiguration' but found no element at all: invalid XML document", parser, null);
    }

    public void setAddDefaultEntities(boolean addDefaultEntities) {
        this.addDefaultEntities = addDefaultEntities;
    }
}

