/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.goodies.common.io;

import java.io.Flushable;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.slf4j.Logger;
import org.sonatype.sisu.goodies.common.Loggers;
import org.sonatype.sisu.goodies.common.UnhandledThrowable;

public final class Flusher {
    @NonNls
    private static final Logger log = Loggers.getLogger(Flusher.class);

    private Flusher() {
    }

    public static void flush(Flushable ... targets) {
        if (targets == null) {
            return;
        }
        for (Flushable target : targets) {
            if (target == null) continue;
            log.trace("Flushing: {}", (Object)target);
            try {
                target.flush();
            }
            catch (IOException e) {
                UnhandledThrowable.onFailure(e);
            }
        }
    }
}

