/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.goodies.common.io;

import java.io.Closeable;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.slf4j.Logger;
import org.sonatype.sisu.goodies.common.Loggers;
import org.sonatype.sisu.goodies.common.UnhandledThrowable;

public final class Closer {
    @NonNls
    private static final Logger log = Loggers.getLogger(Closer.class);

    private Closer() {
    }

    public static void close(Closeable ... targets) {
        if (targets == null) {
            return;
        }
        for (Closeable target : targets) {
            if (target == null) continue;
            log.trace("Closing: {}", (Object)target);
            try {
                target.close();
            }
            catch (IOException e) {
                UnhandledThrowable.onFailure(e);
            }
        }
    }
}

