/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.goodies.common;

import com.google.common.base.Preconditions;
import org.jetbrains.annotations.NonNls;
import org.slf4j.Logger;
import org.sonatype.gossip.Level;
import org.sonatype.sisu.goodies.common.Loggers;
import org.sonatype.sisu.goodies.common.Properties2;

public final class UnhandledThrowable {
    @NonNls
    private static final Logger log = Loggers.getLogger(UnhandledThrowable.class);
    private static final Level level = UnhandledThrowable.getFailureLevel();

    private UnhandledThrowable() {
    }

    private static Level getFailureLevel() {
        Level level = Level.TRACE;
        String value = Properties2.getSystemProperty(UnhandledThrowable.class, "failureLevel", level);
        try {
            return Level.valueOf((String)value.toUpperCase());
        }
        catch (Throwable e) {
            log.error("Invalid level: {}", (Object)value, (Object)e);
            return level;
        }
    }

    public static void onFailure(Throwable cause) {
        Preconditions.checkNotNull((Object)cause);
        if (level.isEnabled(log)) {
            level.log(log, cause.toString(), cause);
        }
    }
}

