/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.goodies.common;

import org.sonatype.sisu.goodies.common.FormatTemplate;

public class SimpleFormat {
    public static final String PLACEHOLDER = "%s";

    private SimpleFormat() {
    }

    public static String format(String template, Object ... args) {
        int placeholderStart;
        template = String.valueOf(template);
        if (args == null || args.length == 0) {
            return template;
        }
        StringBuilder builder = new StringBuilder(template.length() + 16 * args.length);
        int templateStart = 0;
        int i = 0;
        while (i < args.length && (placeholderStart = template.indexOf(PLACEHOLDER, templateStart)) != -1) {
            builder.append(template.substring(templateStart, placeholderStart));
            builder.append(args[i++]);
            templateStart = placeholderStart + 2;
        }
        builder.append(template.substring(templateStart));
        if (i < args.length) {
            builder.append(" [");
            builder.append(args[i++]);
            while (i < args.length) {
                builder.append(", ");
                builder.append(args[i++]);
            }
            builder.append(']');
        }
        return builder.toString();
    }

    public static FormatTemplate template(String format, Object ... args) {
        return new FormatTemplate(format, args){

            @Override
            protected String render() {
                return SimpleFormat.format(this.getFormat(), this.getArgs());
            }
        };
    }
}

