/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.goodies.common;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import org.sonatype.sisu.goodies.common.SafeIterator;

public final class SafeIterable<T>
implements Iterable<T> {
    private final Iterable<T> delegate;

    public SafeIterable(Iterable<T> delegate) {
        this.delegate = (Iterable)Preconditions.checkNotNull(delegate);
    }

    @Override
    public Iterator<T> iterator() {
        return SafeIterator.of(this.delegate);
    }

    public static <T> SafeIterable<T> of(Iterable<T> iterable) {
        return new SafeIterable<T>(iterable);
    }
}

