/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.goodies.common;

import javax.annotation.Nullable;
import org.sonatype.sisu.goodies.common.SimpleFormat;

public abstract class Preconditions {
    private Preconditions() {
    }

    public static <T> Iterable<T> checkNotNullElements(Iterable<T> reference) {
        return Preconditions.checkNotNullElements(reference, "Element at position '%s'");
    }

    public static <T> Iterable<T> checkNotNullElements(Iterable<T> reference, @Nullable Object errorMessage) {
        if (reference != null && reference.iterator().hasNext()) {
            int i = 0;
            for (T element : reference) {
                if (element == null) {
                    String msg = String.valueOf(errorMessage);
                    if (msg != null && msg.contains("%s")) {
                        msg = SimpleFormat.format(msg, i);
                    }
                    throw new NullPointerException(msg);
                }
                ++i;
            }
        }
        return reference;
    }

    public static <T> Iterable<T> checkNotNullElements(Iterable<T> reference, @Nullable String errorMessageTemplate, Object ... errorMessageArgs) {
        if (reference != null && reference.iterator().hasNext()) {
            int i = 0;
            for (T element : reference) {
                if (element == null) {
                    String msg = errorMessageTemplate;
                    if (msg != null && (msg = SimpleFormat.format(msg, errorMessageArgs)) != null && msg.contains("%s")) {
                        msg = SimpleFormat.format(msg, i);
                    }
                    throw new NullPointerException(msg);
                }
                ++i;
            }
        }
        return reference;
    }
}

