/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.goodies.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;

public class NameValue {
    @NonNls
    public static final String SEPARATOR = "=";
    public static final String TRUE = Boolean.TRUE.toString();
    public final String name;
    public final String value;

    private NameValue(@NonNls String name, @NonNls String value) {
        this.name = name;
        this.value = value;
    }

    public static NameValue parse(@NonNls String input) {
        String value;
        String name;
        Preconditions.checkNotNull((Object)input);
        int i = input.indexOf(SEPARATOR);
        if (i == -1) {
            name = input;
            value = TRUE;
        } else {
            name = input.substring(0, i);
            value = input.substring(i + 1, input.length());
        }
        return new NameValue(name.trim(), value);
    }

    public String toString() {
        return String.format("%s%s'%s'", this.name, SEPARATOR, this.value);
    }

    public static Map<String, String> decode(String pattern, String input, boolean trimValue) {
        Preconditions.checkNotNull((Object)input);
        LinkedHashMap parameters = Maps.newLinkedHashMap();
        for (String item : input.split(pattern)) {
            NameValue nv = NameValue.parse(item);
            parameters.put(nv.name, trimValue ? nv.value.trim() : nv.value);
        }
        return parameters;
    }

    public static Map<String, String> decode(String input, boolean trimValue) {
        return NameValue.decode(",|/", input, trimValue);
    }

    public static Map<String, String> decode(String input) {
        return NameValue.decode(input, true);
    }
}

