/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.goodies.common;

import com.google.common.base.Preconditions;
import org.jetbrains.annotations.NonNls;

public final class ByteSize {
    private final long value;
    private final ByteUnit unit;
    private static final ParseConfig[] PARSE_CONFIGS = new ParseConfig[]{new ParseConfig(ByteUnit.BYTES, new String[]{"bytes", "byte", "b"}), new ParseConfig(ByteUnit.KILOBYTES, new String[]{"kilobytes", "kilobyte", "kib", "kb", "k"}), new ParseConfig(ByteUnit.MEGABYTES, new String[]{"megabytes", "megabyte", "mib", "mb", "m"}), new ParseConfig(ByteUnit.GIGABYTES, new String[]{"gigabytes", "gigabyte", "gib", "gb", "g"}), new ParseConfig(ByteUnit.TERABYTES, new String[]{"terabytes", "terabyte", "tib", "tb", "t"})};

    public ByteSize(long value, ByteUnit unit) {
        this.value = value;
        this.unit = (ByteUnit)((Object)Preconditions.checkNotNull((Object)((Object)unit)));
    }

    public long value() {
        return this.value;
    }

    public int valueI() {
        return (int)this.value();
    }

    public ByteUnit unit() {
        return this.unit;
    }

    public long toBytes() {
        return this.unit.asBytes(this.value);
    }

    public int toBytesI() {
        return (int)this.toBytes();
    }

    public ByteSize asBytes() {
        return ByteSize.bytes(this.toBytes());
    }

    public long toKiloBytes() {
        return this.unit.asKiloBytes(this.value);
    }

    public int toKiloBytesI() {
        return (int)this.toKiloBytes();
    }

    public ByteSize asKiloBytes() {
        return ByteSize.kiloBytes(this.toKiloBytes());
    }

    public long toMegaBytes() {
        return this.unit.asMegaBytes(this.value);
    }

    public int toMegaBytesI() {
        return (int)this.toMegaBytes();
    }

    public ByteSize asMegaBytes() {
        return ByteSize.megaBytes(this.toMegaBytes());
    }

    public long toGigaBytes() {
        return this.unit.asGigaBytes(this.value);
    }

    public int toGigaBytesI() {
        return (int)this.toGigaBytes();
    }

    public ByteSize asGigaBytes() {
        return ByteSize.gigaBytes(this.toGigaBytes());
    }

    public long toTeraBytes() {
        return this.unit.asTeraBytes(this.value);
    }

    public int toTeraBytesI() {
        return (int)this.toTeraBytes();
    }

    public ByteSize asTeraBytes() {
        return ByteSize.teraBytes(this.toTeraBytes());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ByteSize that = (ByteSize)obj;
        return this.value == that.value && this.unit == that.unit;
    }

    public int hashCode() {
        int result = (int)(this.value ^ this.value >>> 32);
        result = 31 * result + (this.unit != null ? this.unit.hashCode() : 0);
        return result;
    }

    private String unitName() {
        String name = this.unit.name().toLowerCase();
        if (this.value == 1L) {
            name = name.substring(0, name.length() - 1);
        }
        return name;
    }

    public String toString() {
        return String.format("%d %s", this.value, this.unitName());
    }

    public static ByteSize size(long value, ByteUnit unit) {
        return new ByteSize(value, unit);
    }

    public static ByteSize bytes(long value) {
        return new ByteSize(value, ByteUnit.BYTES);
    }

    public static ByteSize kiloBytes(long value) {
        return new ByteSize(value, ByteUnit.KILOBYTES);
    }

    public static ByteSize megaBytes(long value) {
        return new ByteSize(value, ByteUnit.MEGABYTES);
    }

    public static ByteSize gigaBytes(long value) {
        return new ByteSize(value, ByteUnit.GIGABYTES);
    }

    public static ByteSize teraBytes(long value) {
        return new ByteSize(value, ByteUnit.TERABYTES);
    }

    public static ByteSize parse(@NonNls String value) {
        if (value != null) {
            return ByteSize.doParse(value.trim().toLowerCase());
        }
        return null;
    }

    private static ByteSize doParse(@NonNls String value) {
        for (ParseConfig config : PARSE_CONFIGS) {
            ByteSize t = ByteSize.extract(value, config.unit, config.suffixes);
            if (t == null) continue;
            return t;
        }
        throw new RuntimeException("Unable to parse: " + value);
    }

    private static ByteSize extract(String value, ByteUnit unit, String ... suffixes) {
        String number = null;
        String units = null;
        for (int p = 0; p < value.length(); ++p) {
            if (Character.isDigit(value.charAt(p))) continue;
            number = value.substring(0, p);
            units = value.substring(p, value.length()).trim();
            break;
        }
        if (units != null) {
            for (String suffix : suffixes) {
                if (!suffix.equals(units)) continue;
                long n = Long.parseLong(number.trim());
                return new ByteSize(n, unit);
            }
        }
        return null;
    }

    private static class ParseConfig {
        final ByteUnit unit;
        final String[] suffixes;

        private ParseConfig(ByteUnit unit, String ... suffixes) {
            this.unit = unit;
            this.suffixes = suffixes;
        }
    }

    public static enum ByteUnit {
        BYTES,
        KILOBYTES,
        MEGABYTES,
        GIGABYTES,
        TERABYTES;


        public long asBytes(long value) {
            switch (this) {
                case BYTES: {
                    return value;
                }
                case KILOBYTES: {
                    return value * 1024L;
                }
                case MEGABYTES: {
                    return value * 1024L * 1024L;
                }
                case GIGABYTES: {
                    return value * 1024L * 1024L * 1024L;
                }
                case TERABYTES: {
                    return value * 1024L * 1024L * 1024L * 1024L;
                }
            }
            throw new Error();
        }

        public long asKiloBytes(long value) {
            switch (this) {
                case BYTES: {
                    return value / 1024L;
                }
                case KILOBYTES: {
                    return value;
                }
                case MEGABYTES: {
                    return value * 1024L;
                }
                case GIGABYTES: {
                    return value * 1024L * 1024L;
                }
                case TERABYTES: {
                    return value * 1024L * 1024L * 1024L;
                }
            }
            throw new Error();
        }

        public long asMegaBytes(long value) {
            switch (this) {
                case BYTES: {
                    return value / 1024L * 1024L;
                }
                case KILOBYTES: {
                    return value / 1024L;
                }
                case MEGABYTES: {
                    return value;
                }
                case GIGABYTES: {
                    return value * 1024L;
                }
                case TERABYTES: {
                    return value * 1024L * 1024L;
                }
            }
            throw new Error();
        }

        public long asGigaBytes(long value) {
            switch (this) {
                case BYTES: {
                    return value / 1024L * 1024L * 1024L;
                }
                case KILOBYTES: {
                    return value / 1024L * 1024L;
                }
                case MEGABYTES: {
                    return value / 1024L;
                }
                case GIGABYTES: {
                    return value;
                }
                case TERABYTES: {
                    return value * 1024L;
                }
            }
            throw new Error();
        }

        public long asTeraBytes(long value) {
            switch (this) {
                case BYTES: {
                    return value / 1024L * 1024L * 1024L * 1024L;
                }
                case KILOBYTES: {
                    return value / 1024L * 1024L * 1024L;
                }
                case MEGABYTES: {
                    return value / 1024L * 1024L;
                }
                case GIGABYTES: {
                    return value / 1024L;
                }
                case TERABYTES: {
                    return value;
                }
            }
            throw new Error();
        }
    }
}

