/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.plugin.metadata;

import com.google.common.base.Preconditions;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.nexus.proxy.maven.packaging.ArtifactPackagingMapper;

@Deprecated
public final class GAVCoordinate {
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String classifier;
    private final String type;

    public GAVCoordinate(String groupId, String artifactId, String version) {
        this(groupId, artifactId, version, null, null);
    }

    public GAVCoordinate(String groupId, String artifactId, String version, String classifier, String type) {
        this.groupId = (String)Preconditions.checkNotNull((Object)groupId);
        this.artifactId = (String)Preconditions.checkNotNull((Object)artifactId);
        this.version = (String)Preconditions.checkNotNull((Object)version);
        this.classifier = classifier;
        this.type = type;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getType() {
        return this.type;
    }

    public String getFinalName(ArtifactPackagingMapper packagingMapper) {
        StringBuilder buf = new StringBuilder();
        buf.append(this.artifactId).append('-').append(this.version);
        if (StringUtils.isNotEmpty((String)this.classifier)) {
            buf.append('-').append(this.classifier);
        }
        if (StringUtils.isNotEmpty((String)this.type)) {
            buf.append('.').append(packagingMapper.getExtensionForPackaging(this.type));
        } else {
            buf.append(".jar");
        }
        return buf.toString();
    }

    public boolean matchesByGA(GAVCoordinate coord) {
        return StringUtils.equals((String)this.getGroupId(), (String)coord.getGroupId()) && StringUtils.equals((String)this.getArtifactId(), (String)coord.getArtifactId());
    }

    public boolean equals(Object rhs) {
        if (this == rhs) {
            return true;
        }
        if (!(rhs instanceof GAVCoordinate)) {
            return false;
        }
        return this.toString().equals(rhs.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.groupId).append(':').append(this.artifactId).append(':').append(this.version);
        boolean haveType = StringUtils.isNotEmpty((String)this.type);
        if (StringUtils.isNotEmpty((String)this.classifier)) {
            buf.append(':').append(this.classifier);
        } else if (haveType) {
            buf.append(':');
        }
        if (haveType) {
            buf.append(':').append(this.type);
        }
        return buf.toString();
    }
}

