/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.web.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.VelocityException;
import org.sonatype.nexus.ApplicationStatusSource;
import org.sonatype.nexus.web.BaseUrlHolder;
import org.sonatype.nexus.web.TemplateRenderer;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Singleton
@Named
public class VelocityTemplateRenderer
extends ComponentSupport
implements TemplateRenderer {
    private final Provider<VelocityEngine> velocityEngineProvider;
    private final String applicationVersion;

    @Inject
    public VelocityTemplateRenderer(Provider<VelocityEngine> velocityEngineProvider, ApplicationStatusSource applicationStatusSource) {
        this.velocityEngineProvider = (Provider)Preconditions.checkNotNull(velocityEngineProvider);
        this.applicationVersion = ((ApplicationStatusSource)Preconditions.checkNotNull((Object)applicationStatusSource)).getSystemStatus().getVersion();
    }

    @Override
    public void renderErrorPage(HttpServletRequest request, HttpServletResponse response, int responseCode, @Nullable String reasonPhrase, String errorDescription, @Nullable Throwable exception) throws IOException {
        Preconditions.checkNotNull((Object)request);
        Preconditions.checkNotNull((Object)response);
        Preconditions.checkArgument((responseCode >= 400 ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)errorDescription);
        HashMap dataModel = Maps.newHashMap();
        dataModel.put("nexusRoot", BaseUrlHolder.get());
        dataModel.put("nexusVersion", this.applicationVersion);
        dataModel.put("statusCode", responseCode);
        dataModel.put("statusName", StringEscapeUtils.escapeHtml((String)(Strings.isNullOrEmpty((String)reasonPhrase) ? errorDescription : reasonPhrase)));
        dataModel.put("errorDescription", StringEscapeUtils.escapeHtml((String)errorDescription));
        if (Strings.isNullOrEmpty((String)reasonPhrase)) {
            response.setStatus(responseCode);
        } else {
            response.setStatus(responseCode, reasonPhrase);
        }
        this.render(this.template("/org/sonatype/nexus/web/internal/errorPageContentHtml.vm", VelocityTemplateRenderer.class.getClassLoader()), (Map<String, Object>)dataModel, response);
    }

    @Override
    public TemplateRenderer.TemplateLocator template(final String name, final ClassLoader classLoader) {
        return new TemplateRenderer.TemplateLocator(){

            @Override
            public String name() {
                return name;
            }

            @Override
            public ClassLoader classloader() {
                return classLoader;
            }
        };
    }

    @Override
    public void render(TemplateRenderer.TemplateLocator templateLocator, Map<String, Object> dataModel, HttpServletResponse response) throws IOException {
        this.render(this.getVelocityTemplate(templateLocator), dataModel, response);
    }

    private void render(Template template, Map<String, Object> dataModel, HttpServletResponse response) throws IOException {
        response.setContentType("text/html");
        VelocityContext context = new VelocityContext(dataModel);
        try (ServletOutputStream outputStream = response.getOutputStream();){
            BufferedWriter tmplWriter = template.getEncoding() == null ? new BufferedWriter(new OutputStreamWriter((OutputStream)outputStream)) : new BufferedWriter(new OutputStreamWriter((OutputStream)outputStream, template.getEncoding()));
            template.merge((Context)context, (Writer)tmplWriter);
            ((Writer)tmplWriter).flush();
            response.flushBuffer();
        }
        catch (IOException e) {
            throw e;
        }
        catch (VelocityException e) {
            throw new IOException("Template processing error: " + (Object)((Object)e), e);
        }
    }

    private Template getVelocityTemplate(TemplateRenderer.TemplateLocator templateLocator) {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(templateLocator.classloader());
            Template template = ((VelocityEngine)this.velocityEngineProvider.get()).getTemplate(templateLocator.name());
            return template;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot get the template with name " + templateLocator.name(), e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }
}

