/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.web.internal;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.security.Principal;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.web.filter.mgt.FilterChainResolver;
import org.apache.shiro.web.mgt.WebSecurityManager;
import org.apache.shiro.web.servlet.AbstractShiroFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.security.SecuritySystem;
import org.sonatype.security.internal.UserIdMdcHelper;

@Named
@Singleton
public class SecurityFilter
extends AbstractShiroFilter {
    private static final Logger log = LoggerFactory.getLogger(SecurityFilter.class);
    public static final String ATTR_USER_PRINCIPAL = "nexus.user.principal";
    public static final String ATTR_USER_ID = "nexus.user.id";

    @Inject
    public SecurityFilter(SecuritySystem securitySystem, FilterChainResolver filterChainResolver) {
        Preconditions.checkNotNull((Object)securitySystem);
        WebSecurityManager sm = (WebSecurityManager)securitySystem.getSecurityManager();
        log.trace("Security manager: {}", (Object)sm);
        this.setSecurityManager(sm);
        Preconditions.checkNotNull((Object)filterChainResolver);
        log.trace("Filter chain resolver: {}", (Object)filterChainResolver);
        this.setFilterChainResolver(filterChainResolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeChain(ServletRequest request, ServletResponse response, FilterChain origChain) throws IOException, ServletException {
        HttpServletRequest httpRequest;
        Principal p;
        UserIdMdcHelper.set();
        if (request instanceof HttpServletRequest && (p = (httpRequest = (HttpServletRequest)request).getUserPrincipal()) != null) {
            httpRequest.setAttribute(ATTR_USER_PRINCIPAL, (Object)p);
            httpRequest.setAttribute(ATTR_USER_ID, (Object)p.getName());
        }
        try {
            super.executeChain(request, response, origChain);
        }
        finally {
            UserIdMdcHelper.unset();
        }
    }
}

