/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.web.internal;

import com.google.inject.Inject;
import com.google.inject.servlet.FilterPipeline;
import com.google.inject.servlet.GuiceFilter;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public final class NexusGuiceFilter
extends GuiceFilter {
    @Inject
    static List<FilterPipeline> pipelines = Collections.emptyList();

    public NexusGuiceFilter() {
        super((FilterPipeline)new MultiFilterPipeline());
    }

    static final class MultiFilterChain
    implements FilterChain {
        private final Iterator<FilterPipeline> itr = pipelines.iterator();
        private final FilterChain defaultChain;

        MultiFilterChain(FilterChain chain) {
            this.defaultChain = chain;
        }

        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            if (this.itr.hasNext()) {
                this.itr.next().dispatch(request, response, (FilterChain)this);
            } else {
                this.defaultChain.doFilter(request, response);
            }
        }
    }

    static final class MultiFilterPipeline
    implements FilterPipeline {
        MultiFilterPipeline() {
        }

        public void initPipeline(ServletContext context) throws ServletException {
            for (FilterPipeline p : pipelines) {
                p.initPipeline(context);
            }
        }

        public void dispatch(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            new MultiFilterChain(chain).doFilter(request, response);
        }

        public void destroyPipeline() {
            for (FilterPipeline p : pipelines) {
                p.destroyPipeline();
            }
        }
    }
}

