/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.web.internal;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.eclipse.sisu.EagerSingleton;
import org.sonatype.nexus.proxy.events.NexusStartedEvent;
import org.sonatype.nexus.proxy.events.NexusStoppedEvent;
import org.sonatype.nexus.security.FilterChain;
import org.sonatype.security.web.ProtectedPathManager;
import org.sonatype.sisu.goodies.eventbus.EventBus;

@Named
@EagerSingleton
public class FilterChainInstaller {
    private final EventBus eventBus;
    private final Provider<ProtectedPathManager> protectedPathManager;
    private final List<FilterChain> filterChains;

    @Inject
    public FilterChainInstaller(EventBus eventBus, Provider<ProtectedPathManager> protectedPathManager, List<FilterChain> filterChains) {
        this.eventBus = (EventBus)Preconditions.checkNotNull((Object)eventBus);
        this.protectedPathManager = (Provider)Preconditions.checkNotNull(protectedPathManager);
        this.filterChains = (List)Preconditions.checkNotNull(filterChains);
        eventBus.register((Object)this);
    }

    @Subscribe
    public void onEvent(NexusStartedEvent event) {
        for (FilterChain filterChain : this.filterChains) {
            ((ProtectedPathManager)this.protectedPathManager.get()).addProtectedResource(filterChain.getPathPattern(), filterChain.getFilterExpression());
        }
    }

    @Subscribe
    public void onEvent(NexusStoppedEvent event) {
        this.eventBus.unregister((Object)this);
    }
}

