/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.web.internal;

import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sonatype.nexus.web.TemplateRenderer;
import org.sonatype.nexus.web.WebUtils;

@Named
@Singleton
public class ErrorPageServlet
extends HttpServlet {
    private final TemplateRenderer templateRenderer;
    private final WebUtils webUtils;

    @Inject
    public ErrorPageServlet(TemplateRenderer templateRenderer, WebUtils webUtils) {
        this.templateRenderer = (TemplateRenderer)Preconditions.checkNotNull((Object)templateRenderer);
        this.webUtils = (WebUtils)Preconditions.checkNotNull((Object)webUtils);
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.webUtils.addNoCacheResponseHeaders(response);
        Integer errorCode = (Integer)request.getAttribute("javax.servlet.error.status_code");
        String errorMessage = (String)request.getAttribute("javax.servlet.error.message");
        Throwable cause = (Throwable)request.getAttribute("javax.servlet.error.exception");
        if (errorCode == null) {
            errorCode = 404;
            errorMessage = "Not found";
        }
        if (errorMessage == null) {
            errorMessage = "Unknown error";
        }
        this.templateRenderer.renderErrorPage(request, response, errorCode, null, errorMessage, cause);
    }
}

